/*
 * Decompiled with CFR 0.152.
 */
package org.andya.confluence.utils;

import com.atlassian.confluence.core.ConfluenceEntityObject;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.renderer.PageContext;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.v2.RenderMode;
import com.atlassian.renderer.v2.RenderUtils;
import com.atlassian.renderer.v2.SubRenderer;
import com.atlassian.renderer.v2.macro.MacroException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Map;
import org.andya.confluence.plugins.metadata.aop.HtmlEncoding;
import org.andya.confluence.plugins.metadata.aop.HtmlEncodingAspect;
import org.andya.confluence.plugins.metadata.aop.HtmlEncodingParameter;
import org.andya.confluence.utils.MacroUtils$AjcClosure5;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MacroUtils {
    private static final Logger log;
    private static final String DEBUG_KEY = "debug";
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;

    public static String getStringParameter(Map parameters, String name, boolean required) throws MacroException {
        String value = (String)parameters.get(name);
        if (value == null && required) {
            throw new MacroException("Required parameter \"" + name + "\" not provided");
        }
        return value;
    }

    public static String getStringParameter(Map parameters, String name, String defaultValue) throws MacroException {
        String value = MacroUtils.getStringParameter(parameters, name, false);
        return value != null ? value : defaultValue;
    }

    public static Integer getIntegerParameter(Map parameters, String name) throws MacroException {
        String value = MacroUtils.getStringParameter(parameters, name, false);
        if (value == null) {
            return null;
        }
        try {
            return Integer.valueOf(value);
        }
        catch (NumberFormatException e) {
            throw new MacroException("Non-integer value for parameter \"" + name + "\": " + value);
        }
    }

    public static int getIntParameter(Map parameters, String name, int defaultValue) throws MacroException {
        Integer result = MacroUtils.getIntegerParameter(parameters, name);
        return result != null ? result : defaultValue;
    }

    public static boolean getBooleanParameter(Map parameters, String name) throws MacroException {
        return MacroUtils.getBooleanParameter(parameters, name, false);
    }

    public static boolean getBooleanParameter(Map parameters, String name, boolean defaultValue) throws MacroException {
        return MacroUtils.getBooleanParameter(parameters, name, "true", defaultValue);
    }

    public static boolean getBooleanParameter(Map parameters, String name, String trueKey, boolean defaultValue) throws MacroException {
        String value = MacroUtils.getStringParameter(parameters, name, null);
        return value != null ? trueKey.equals(value) : defaultValue;
    }

    public static boolean isDebugMode(Map parameters) {
        try {
            return MacroUtils.getBooleanParameter(parameters, DEBUG_KEY, false);
        }
        catch (MacroException e) {
            return false;
        }
    }

    @HtmlEncoding
    public static String getExceptionString(Throwable e) {
        Throwable throwable = e;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, null, null, (Object)throwable);
        return (String)MacroUtils.getExceptionString_aroundBody1$advice(throwable, joinPoint, HtmlEncodingAspect.aspectOf(), (ProceedingJoinPoint)joinPoint);
    }

    @HtmlEncoding
    public static String getExceptionMessage(Throwable e) {
        Throwable throwable = e;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, null, null, (Object)throwable);
        return (String)MacroUtils.getExceptionMessage_aroundBody3$advice(throwable, joinPoint, HtmlEncodingAspect.aspectOf(), (ProceedingJoinPoint)joinPoint);
    }

    public static String showRenderedExceptionString(Map parameters, String title, Throwable e) {
        log.error("Exception thrown from macro:" + e.getMessage());
        String exceptionString = e.getMessage();
        if (MacroUtils.isDebugMode(parameters)) {
            return "<div class=\"error\"><h3>" + title + "</h3>\n<pre>" + exceptionString + "</pre></div>\n";
        }
        return RenderUtils.blockError((String)(title + ":"), (String)exceptionString);
    }

    @HtmlEncodingParameter
    public static String showRenderedExceptionString(Map parameters, String title, String message) {
        Map map = parameters;
        String string = title;
        String string2 = message;
        Object[] objectArray = new Object[]{map, string, string2};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, null, null, (Object[])objectArray);
        Object[] objectArray2 = new Object[]{map, string, string2, joinPoint};
        MacroUtils$AjcClosure5 macroUtils$AjcClosure5 = new MacroUtils$AjcClosure5(objectArray2);
        return (String)HtmlEncodingAspect.aspectOf().encodeMetadataParameter(macroUtils$AjcClosure5.linkClosureAndJoinPoint(65536));
    }

    public static String showUnrenderedExceptionString(Map parameters, String title, Throwable e) {
        if (MacroUtils.isDebugMode(parameters)) {
            return "{warning:title=" + title + "}{noformat}" + MacroUtils.getExceptionString(e) + "{noformat}{warning}\n";
        }
        return "{warning:title=" + title + "}" + MacroUtils.getExceptionMessage(e) + "{warning}\n";
    }

    public static String renderValue(SubRenderer subRenderer, RenderContext renderContext, String value) {
        return subRenderer.render(value != null ? value : "", renderContext, renderContext.getRenderMode().and(RenderMode.suppress((long)256L)));
    }

    public static String renderValue(SubRenderer subRenderer, RenderContext renderContext, ConfluenceEntityObject ceo, String value) {
        if (renderContext instanceof PageContext && ceo instanceof ContentEntityObject) {
            PageContext pageContext = new PageContext((ContentEntityObject)ceo, (PageContext)renderContext);
            return MacroUtils.renderValue(subRenderer, (RenderContext)pageContext, value);
        }
        return MacroUtils.renderValue(subRenderer, renderContext, value);
    }

    static {
        MacroUtils.ajc$preClinit();
        log = LoggerFactory.getLogger(MacroUtils.class);
    }

    private static final /* synthetic */ String getExceptionString_aroundBody0(Throwable e, JoinPoint joinPoint) {
        StringWriter writer = new StringWriter();
        e.printStackTrace(new PrintWriter(writer));
        return writer.toString();
    }

    private static final /* synthetic */ Object getExceptionString_aroundBody1$advice(Throwable e, JoinPoint thisJoinPoint, HtmlEncodingAspect ajc$aspectInstance, ProceedingJoinPoint pjp) {
        HtmlEncodingAspect.ajc$inlineAccessFieldGet$org_andya_confluence_plugins_metadata_aop_HtmlEncodingAspect$org_andya_confluence_plugins_metadata_aop_HtmlEncodingAspect$log().debug(pjp.toShortString());
        ProceedingJoinPoint proceedingJoinPoint = pjp;
        String value = MacroUtils.getExceptionString_aroundBody0(e, (JoinPoint)proceedingJoinPoint);
        return HtmlEncodingAspect.ajc$inlineAccessMethod$org_andya_confluence_plugins_metadata_aop_HtmlEncodingAspect$org_andya_confluence_plugins_metadata_aop_HtmlEncodingAspect$escapeHtml(ajc$aspectInstance, value);
    }

    private static final /* synthetic */ String getExceptionMessage_aroundBody2(Throwable e, JoinPoint joinPoint) {
        String message = e.getMessage();
        if (message == null) {
            message = e.toString();
        }
        return message;
    }

    private static final /* synthetic */ Object getExceptionMessage_aroundBody3$advice(Throwable e, JoinPoint thisJoinPoint, HtmlEncodingAspect ajc$aspectInstance, ProceedingJoinPoint pjp) {
        HtmlEncodingAspect.ajc$inlineAccessFieldGet$org_andya_confluence_plugins_metadata_aop_HtmlEncodingAspect$org_andya_confluence_plugins_metadata_aop_HtmlEncodingAspect$log().debug(pjp.toShortString());
        ProceedingJoinPoint proceedingJoinPoint = pjp;
        String value = MacroUtils.getExceptionMessage_aroundBody2(e, (JoinPoint)proceedingJoinPoint);
        return HtmlEncodingAspect.ajc$inlineAccessMethod$org_andya_confluence_plugins_metadata_aop_HtmlEncodingAspect$org_andya_confluence_plugins_metadata_aop_HtmlEncodingAspect$escapeHtml(ajc$aspectInstance, value);
    }

    static final /* synthetic */ String showRenderedExceptionString_aroundBody4(Map parameters, String title, String message, JoinPoint joinPoint) {
        log.error("Exception thrown from macro:" + message);
        if (MacroUtils.isDebugMode(parameters)) {
            return "<div class=\"error\"><h3>" + title + "<h3>\n<pre>" + message + "</pre></div>\n";
        }
        return RenderUtils.blockError((String)(title + ":"), (String)message);
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("MacroUtils.java", MacroUtils.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "getExceptionString", "org.andya.confluence.utils.MacroUtils", "java.lang.Throwable", "e", "", "java.lang.String"), 91);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "getExceptionMessage", "org.andya.confluence.utils.MacroUtils", "java.lang.Throwable", "e", "", "java.lang.String"), 98);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "showRenderedExceptionString", "org.andya.confluence.utils.MacroUtils", "java.util.Map:java.lang.String:java.lang.String", "parameters:title:message", "", "java.lang.String"), 121);
    }
}

