/*
 * Decompiled with CFR 0.152.
 */
package org.andya.confluence.utils.page.resolver;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.renderer.PageContext;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.v2.macro.MacroException;
import org.andya.confluence.utils.page.resolver.contract.PageResolver;
import org.apache.commons.lang3.StringUtils;

public class TitlePageResolverImpl
implements PageResolver {
    protected final PageManager pageManager;

    public TitlePageResolverImpl(PageManager pageManager) {
        this.pageManager = pageManager;
    }

    @Override
    public Page resolve(String value, RenderContext renderContext, String spaceKey) throws MacroException {
        Page resolvedPage;
        ContentEntityObject ceo;
        if (renderContext instanceof PageContext && (ceo = ((PageContext)renderContext).getEntity()) instanceof Page && StringUtils.isBlank((CharSequence)spaceKey)) {
            spaceKey = ((Page)ceo).getSpaceKey();
        }
        if ((resolvedPage = this.pageManager.getPage(spaceKey, value)) == null) {
            throw new MacroException("No such page \"" + value + "\"");
        }
        return resolvedPage;
    }
}

