/*
 * Decompiled with CFR 0.152.
 */
package org.andya.confluence.utils.page.resolver;

import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.v2.macro.MacroException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.andya.confluence.utils.page.resolver.SpacePageResolverImpl;
import org.andya.confluence.utils.page.resolver.contract.PageResolver;

public class IdPageResolverImpl
extends SpacePageResolverImpl
implements PageResolver {
    public IdPageResolverImpl(PageManager pageManager) {
        super(pageManager);
    }

    @Override
    public Page resolve(String value, RenderContext renderContext, String spaceKey) throws MacroException {
        try {
            return super.resolve(value, renderContext, spaceKey);
        }
        catch (MacroException macroException) {
            Pattern spacePagePattern = Pattern.compile("^id:(?<pageId>\\d+$)");
            Matcher matcher = spacePagePattern.matcher(value);
            if (matcher.find()) {
                String pageId = matcher.group("pageId");
                Page resolvedPage = this.pageManager.getPage(Long.parseLong(pageId));
                if (resolvedPage == null) {
                    throw new MacroException("No such page with id" + pageId);
                }
                return resolvedPage;
            }
            throw new MacroException("Id page pattern is not correct, prolly id is not a number: " + value);
        }
    }
}

