/*
 * Decompiled with CFR 0.152.
 */
package org.andya.confluence.utils.page;

import com.atlassian.confluence.labels.Label;
import com.atlassian.confluence.pages.Page;
import com.atlassian.renderer.v2.macro.MacroException;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.andya.confluence.utils.page.AbstractLabelPageSource;
import org.andya.confluence.utils.page.PageSearchContext;
import org.andya.confluence.utils.page.PageSource;
import org.andya.confluence.utils.parse.AndExpression;
import org.andya.confluence.utils.parse.Expression;
import org.andya.confluence.utils.parse.ExpressionVisitor;
import org.andya.confluence.utils.parse.LabelExpression;
import org.andya.confluence.utils.parse.OrExpression;

public class LabelFilterPageSource
extends AbstractLabelPageSource {
    private final PageSource child;

    public LabelFilterPageSource(PageSource child) {
        this.child = child;
    }

    @Override
    public List<Page> getPages(PageSearchContext context) throws MacroException {
        List<Page> entities = this.child.getPages(context);
        LinkedList<Page> filtered = new LinkedList<Page>();
        Expression expression = this.getExpression(context);
        for (Page page : entities) {
            LabelInterpreter interpreter = new LabelInterpreter(page);
            expression.accept(interpreter);
            if (!interpreter.include) continue;
            filtered.add(page);
        }
        return filtered;
    }

    static final class LabelInterpreter
    implements ExpressionVisitor {
        private boolean include;
        private final Set<String> labelNames = new HashSet<String>();

        LabelInterpreter(Page p) {
            List labels = p.getLabels();
            for (Label label : labels) {
                this.labelNames.add(label.getName());
            }
        }

        @Override
        public void visit(OrExpression or) {
            or.getLeft().accept(this);
            boolean left = this.include;
            or.getRight().accept(this);
            boolean right = this.include;
            this.include = left || right;
        }

        @Override
        public void visit(AndExpression and) {
            and.getLeft().accept(this);
            boolean left = this.include;
            and.getRight().accept(this);
            boolean right = this.include;
            this.include = left && right;
        }

        @Override
        public void visit(LabelExpression label) {
            this.include = this.labelNames.contains(label.getLabel());
        }
    }
}

