/*
 * Decompiled with CFR 0.152.
 */
package org.andya.confluence.utils.page;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.PartialList;
import com.atlassian.confluence.labels.Label;
import com.atlassian.confluence.labels.LabelManager;
import com.atlassian.confluence.labels.LabelParser;
import com.atlassian.confluence.labels.ParsedLabelName;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.user.User;
import java.util.LinkedList;
import java.util.List;
import org.andya.confluence.plugins.metadata.AbstractMetadataMacro;
import org.andya.confluence.utils.page.PageSearchContext;
import org.andya.confluence.utils.parse.AndExpression;
import org.andya.confluence.utils.parse.ExpressionVisitor;
import org.andya.confluence.utils.parse.LabelExpression;
import org.andya.confluence.utils.parse.OrExpression;
import org.apache.commons.lang3.StringUtils;

class LabelExpressionVisitor
implements ExpressionVisitor {
    private List<Page> pages;
    private final PageSearchContext context;

    public LabelExpressionVisitor(PageSearchContext context) {
        this.context = context;
    }

    @Override
    public void visit(OrExpression or) {
        or.getLeft().accept(this);
        List<Page> pagesLeft = this.pages;
        or.getRight().accept(this);
        List<Page> pagesRight = this.pages;
        pagesLeft.addAll(pagesRight);
        this.pages = pagesLeft;
    }

    @Override
    public void visit(AndExpression and) {
        and.getLeft().accept(this);
        List<Page> pagesLeft = this.pages;
        and.getRight().accept(this);
        List<Page> pagesRight = this.pages;
        pagesLeft.retainAll(pagesRight);
        this.pages = pagesLeft;
    }

    @Override
    public void visit(LabelExpression labelExpression) {
        this.pages = new LinkedList<Page>();
        LabelManager labelManager = this.context.getLabelManager();
        String spaceKey = this.context.getSpaceKey();
        String labelName = labelExpression.getLabel();
        ParsedLabelName ref = LabelParser.parse((String)labelName, (User)AuthenticatedUserThreadLocal.get());
        if (ref == null) {
            return;
        }
        Label label = labelManager.getLabel(ref);
        if (label == null) {
            return;
        }
        PartialList entities = StringUtils.isNotBlank((CharSequence)spaceKey) ? labelManager.getContentInSpaceForLabel(0, this.context.getMaxResults(), spaceKey, label) : labelManager.getContentForLabel(0, this.context.getMaxResults(), label);
        List entitiesList = entities.getList();
        if (entitiesList.size() >= this.context.getMaxResults()) {
            AbstractMetadataMacro.reportLimitHitFlag.set(true);
        }
        for (ContentEntityObject entity : entitiesList) {
            if (!(entity instanceof Page) || entity.isDeleted()) continue;
            this.pages.add((Page)entity);
        }
    }

    public List<Page> getPages() {
        return this.pages;
    }
}

