/*
 * Decompiled with CFR 0.152.
 */
package org.andya.confluence.plugins.metadata.renderers;

import com.atlassian.confluence.content.render.xhtml.LinkRenderer;
import com.atlassian.confluence.core.ConfluenceEntityObject;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.v2.SubRenderer;
import com.atlassian.renderer.v2.macro.MacroException;
import com.atlassian.sal.api.message.I18nResolver;
import java.util.Arrays;
import java.util.List;
import org.andya.confluence.plugins.metadata.AbstractMetadataMacro;
import org.andya.confluence.plugins.metadata.MetadataUtils;
import org.andya.confluence.plugins.metadata.aop.HtmlEncodingAspect;
import org.andya.confluence.plugins.metadata.aop.HtmlEncodingParameter;
import org.andya.confluence.plugins.metadata.model.MetadataContent;
import org.andya.confluence.plugins.metadata.model.MetadataValue;
import org.andya.confluence.plugins.metadata.model.ReportStatistics;
import org.andya.confluence.plugins.metadata.renderers.MetadataRenderer;
import org.andya.confluence.plugins.metadata.renderers.MetadataSingleValueRenderer;
import org.andya.confluence.plugins.metadata.renderers.MetadataTableRenderer$AjcClosure1;
import org.apache.commons.lang3.BooleanUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;

public class MetadataTableRenderer
implements MetadataRenderer {
    private final SubRenderer subRenderer;
    private final MetadataSingleValueRenderer metadataValueRenderer;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    public MetadataTableRenderer(SubRenderer subRenderer, LinkRenderer linkRenderer) {
        this.subRenderer = subRenderer;
        this.metadataValueRenderer = new MetadataSingleValueRenderer(linkRenderer);
    }

    public SubRenderer getSubRenderer() {
        return this.subRenderer;
    }

    @Override
    public String render(RenderContext renderContext, List<MetadataContent> contents, int maxResults, String[] columns, String commaDelimitedTotals, String linkColumn, I18nResolver i18nResolver) throws MacroException {
        boolean showTotals;
        int totalResults = contents.size();
        boolean truncated = false;
        if (totalResults > maxResults) {
            contents = contents.subList(0, maxResults);
            truncated = true;
        }
        ReportStatistics statistics = new ReportStatistics(columns.length);
        boolean bl = showTotals = commaDelimitedTotals.length() > 0;
        if (showTotals) {
            List<String> totalColumns = Arrays.asList(commaDelimitedTotals.split(","));
            for (int i = 0; i < columns.length; ++i) {
                String column = columns[i];
                statistics.setShouldTotal(i, totalColumns.contains(column));
            }
        }
        StringBuilder html = new StringBuilder();
        if (BooleanUtils.isTrue((Boolean)AbstractMetadataMacro.reportLimitHitFlag.get())) {
            html.append(MetadataUtils.getPageLimitMessage(this.getEntityName(contents, linkColumn), i18nResolver));
        }
        html.append("<table class='confluenceTable'>\n");
        this.writeHeadings(html, Arrays.copyOf(columns, columns.length));
        for (MetadataContent content : contents) {
            this.writeTableRow(html, content, renderContext, columns, linkColumn, statistics);
        }
        if (truncated) {
            html.append("<tr><td colspan=").append(columns.length).append(" class='confluenceTd'>");
            html.append("First ").append(maxResults).append(" results of ").append(totalResults).append("...");
            html.append("</td></tr>\n");
        }
        if (showTotals) {
            this.writeTotals(html, statistics);
        }
        html.append("</table>\n");
        return html.toString();
    }

    @HtmlEncodingParameter
    private void writeHeadings(StringBuilder html, String[] columns) {
        StringBuilder stringBuilder = html;
        String[] stringArray = columns;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)stringBuilder, (Object)stringArray);
        Object[] objectArray = new Object[]{this, stringBuilder, stringArray, joinPoint};
        MetadataTableRenderer$AjcClosure1 metadataTableRenderer$AjcClosure1 = new MetadataTableRenderer$AjcClosure1(objectArray);
        HtmlEncodingAspect.aspectOf().encodeMetadataParameter(metadataTableRenderer$AjcClosure1.linkClosureAndJoinPoint(69648));
    }

    private void writeTableRow(StringBuilder html, MetadataContent content, RenderContext renderContext, String[] columns, String linkColumn, ReportStatistics statistics) {
        SubRenderer subRenderer = this.getSubRenderer();
        html.append("<tr>");
        ConfluenceEntityObject ceo = content.getEntity();
        AbstractPage page = ceo instanceof AbstractPage ? (AbstractPage)ceo : null;
        for (int i = 0; i < columns.length; ++i) {
            String column = columns[i];
            MetadataValue value = content.getMetadataValue(column);
            html.append("<td class='confluenceTd'>");
            String valueString = this.metadataValueRenderer.renderSingleValue(html, renderContext, linkColumn, subRenderer, ceo, page, column, value);
            html.append("</td>");
            statistics.recordValue(i, valueString);
        }
        html.append("</tr>\n");
    }

    private void writeTotals(StringBuilder html, ReportStatistics statistics) {
        html.append("<tr>");
        int columnCount = statistics.getColumnCount();
        for (int i = 0; i < columnCount; ++i) {
            html.append("<td class='confluenceTd'>");
            if (statistics.shouldTotal(i)) {
                html.append("<b>");
                html.append(statistics.getTotalString(i));
                html.append("</b>");
            } else if (i == 0) {
                html.append("<b>Totals</b>");
            } else {
                html.append("&nbsp;");
            }
            html.append("</td>");
        }
        html.append("</tr>\n");
    }

    static {
        MetadataTableRenderer.ajc$preClinit();
    }

    static final /* synthetic */ void writeHeadings_aroundBody0(MetadataTableRenderer ajc$this, StringBuilder html, String[] columns, JoinPoint joinPoint) {
        html.append("<tr>");
        for (String column : columns) {
            html.append("<th class='confluenceTh'>");
            html.append(column);
            html.append("</th>");
        }
        html.append("</tr>\n");
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("MetadataTableRenderer.java", MetadataTableRenderer.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "writeHeadings", "org.andya.confluence.plugins.metadata.renderers.MetadataTableRenderer", "java.lang.StringBuilder:[Ljava.lang.String;", "html:columns", "", "void"), 94);
    }
}

