/*
 * Decompiled with CFR 0.152.
 */
package org.andya.confluence.plugins.metadata.blogs;

import com.atlassian.confluence.api.model.Expansion;
import com.atlassian.confluence.api.model.content.Content;
import com.atlassian.confluence.api.model.pagination.PageRequest;
import com.atlassian.confluence.api.model.pagination.PageResponse;
import com.atlassian.confluence.api.model.pagination.SimplePageRequest;
import com.atlassian.confluence.pages.BlogPost;
import com.atlassian.confluence.security.Permission;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.v2.RenderMode;
import com.atlassian.renderer.v2.macro.MacroException;
import com.atlassian.user.User;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.andya.confluence.plugins.metadata.AbstractMetadataMacro;
import org.andya.confluence.plugins.metadata.MetadataUtils;
import org.andya.confluence.plugins.metadata.model.MetadataContent;
import org.andya.confluence.plugins.metadata.model.MetadataSortOrder;
import org.andya.confluence.plugins.metadata.renderers.MetadataRenderer;
import org.andya.confluence.plugins.metadata.space.AbstractSpaceMetadataMacro;
import org.andya.confluence.utils.ContentUtils;
import org.andya.confluence.utils.MacroUtils;
import org.apache.commons.lang3.StringUtils;

public class BlogPostsReportMacro
extends AbstractSpaceMetadataMacro {
    public BlogPostsReportMacro() {
        super("blog-posts-report");
    }

    public boolean hasBody() {
        return false;
    }

    public RenderMode getBodyRenderMode() {
        return RenderMode.NO_RENDER;
    }

    @Override
    public String doExecute(Map parameters, String body, RenderContext renderContext) throws MacroException {
        try {
            String commaDelimitedColumns = MacroUtils.getStringParameter(parameters, "0", true);
            List<MetadataContent> contents = this.getMatchingBlogPosts(parameters, renderContext, true);
            String[] columns = commaDelimitedColumns.split(",");
            String commaDelimitedTotals = MacroUtils.getStringParameter(parameters, "totals", "");
            MetadataRenderer renderer = this.getMetadataRenderer(parameters);
            return renderer.render(renderContext, contents, this.getMaxResultsForPages(parameters), columns, commaDelimitedTotals, "Space", this.getI18nResolver());
        }
        catch (Exception e) {
            return MacroUtils.showRenderedExceptionString(parameters, "Unable to render macro", e.getMessage());
        }
    }

    public List<MetadataContent> getMatchingBlogPosts(Map parameters, RenderContext renderContext, boolean ordered) throws MacroException {
        String spaceKey = MacroUtils.getStringParameter(parameters, "space", "");
        List blogPosts = this.searchBlogPostsInSpaceWithCql(spaceKey, this.getSystemMaxResultsForPages());
        blogPosts = this.getPermissionManager().getPermittedEntities((User)this.getUser(), Permission.VIEW, blogPosts);
        List<MetadataContent> contents = MetadataUtils.getMetadataContent(this.getContentService(), blogPosts);
        if (ordered) {
            String commaDelimitedSort = MacroUtils.getStringParameter(parameters, "sort", "");
            MetadataSortOrder[] sortOrders = MetadataSortOrder.getMetadataSortOrders(commaDelimitedSort);
            Comparator<MetadataContent> comparator = MetadataSortOrder.getComparator(sortOrders, "Blog Post");
            contents.sort(comparator);
        }
        return contents;
    }

    private List<BlogPost> searchBlogPostsInSpaceWithCql(String spaceKey, int maxResults) {
        PageResponse pageResponse;
        ArrayList<BlogPost> blogPosts = new ArrayList<BlogPost>();
        StringBuilder cqlQuery = new StringBuilder("type = blogpost");
        if (StringUtils.isNotBlank((CharSequence)spaceKey)) {
            String quotedKey = ContentUtils.quoteString(spaceKey);
            cqlQuery.append(" AND space.key = ").append(quotedKey);
        }
        cqlQuery.append(" ORDER BY title ASC");
        do {
            pageResponse = this.getCqlSearchService().searchContent(cqlQuery.toString(), (PageRequest)new SimplePageRequest(blogPosts.size(), 500), new Expansion[0]);
            for (Content content : pageResponse.getResults()) {
                blogPosts.add(this.getPageManager().getBlogPost(content.getId().asLong()));
            }
        } while (pageResponse.hasMore() && blogPosts.size() < maxResults);
        if (blogPosts.size() >= maxResults) {
            AbstractMetadataMacro.reportLimitHitFlag.set(true);
        }
        return blogPosts;
    }
}

