/*
 * Decompiled with CFR 0.152.
 */
package org.andya.confluence.plugins.metadata.renderers;

import com.atlassian.confluence.content.render.xhtml.LinkRenderer;
import com.atlassian.confluence.core.ConfluenceEntityObject;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.v2.SubRenderer;
import com.atlassian.renderer.v2.macro.MacroException;
import com.atlassian.sal.api.message.I18nResolver;
import java.util.Arrays;
import java.util.List;
import org.andya.confluence.plugins.metadata.AbstractMetadataMacro;
import org.andya.confluence.plugins.metadata.MetadataUtils;
import org.andya.confluence.plugins.metadata.model.MetadataContent;
import org.andya.confluence.plugins.metadata.model.MetadataValue;
import org.andya.confluence.plugins.metadata.model.ReportStatistics;
import org.andya.confluence.plugins.metadata.renderers.MetadataRenderer;
import org.andya.confluence.plugins.metadata.renderers.MetadataSingleValueRenderer;
import org.apache.commons.lang3.BooleanUtils;

public class MetadataListRenderer
implements MetadataRenderer {
    private final SubRenderer subRenderer;
    private final String style;
    private final MetadataSingleValueRenderer metadataValueRenderer;

    public MetadataListRenderer(SubRenderer subRenderer, String style, LinkRenderer linkRenderer) {
        this.subRenderer = subRenderer;
        this.style = style;
        this.metadataValueRenderer = new MetadataSingleValueRenderer(linkRenderer);
    }

    public SubRenderer getSubRenderer() {
        return this.subRenderer;
    }

    public String getStyle() {
        return this.style;
    }

    @Override
    public String render(RenderContext renderContext, List<MetadataContent> contents, int maxResults, String[] columns, String commaDelimitedTotals, String linkColumn, I18nResolver i18nResolver) throws MacroException {
        boolean showTotals;
        int totalResults = contents.size();
        boolean truncated = false;
        if (totalResults > maxResults) {
            contents = contents.subList(0, maxResults);
            truncated = true;
        }
        ReportStatistics statistics = new ReportStatistics(columns.length);
        boolean bl = showTotals = commaDelimitedTotals.length() > 0;
        if (showTotals) {
            List<String> totalColumns = Arrays.asList(commaDelimitedTotals.split(","));
            for (int i = 0; i < columns.length; ++i) {
                String column = columns[i];
                statistics.setShouldTotal(i, totalColumns.contains(column));
            }
        }
        StringBuilder html = new StringBuilder();
        if (BooleanUtils.isTrue((Boolean)AbstractMetadataMacro.reportLimitHitFlag.get())) {
            html.append(MetadataUtils.getPageLimitMessage(this.getEntityName(contents, linkColumn), i18nResolver));
        }
        String listType = null;
        String style = this.getStyle();
        if ("ul".equals(style)) {
            listType = "ul";
        } else if ("ol".equals(style)) {
            listType = "ol";
        }
        if (listType != null) {
            html.append("<").append(listType).append(">\n");
        }
        for (MetadataContent content : contents) {
            if (listType != null) {
                html.append("<li>");
            }
            this.writeItem(html, content, renderContext, columns, linkColumn, statistics);
            if (listType != null) {
                html.append("</li>\n");
                continue;
            }
            html.append("<br>\n");
        }
        if (truncated) {
            if (listType != null) {
                html.append("<li>");
            }
            html.append("First ").append(maxResults).append(" results of ").append(totalResults).append("...");
            if (listType != null) {
                html.append("</li>\n");
            } else {
                html.append("<br>\n");
            }
        }
        if (listType != null) {
            html.append("</").append(listType).append(">\n");
        }
        return html.toString();
    }

    private void writeItem(StringBuilder html, MetadataContent content, RenderContext renderContext, String[] columns, String linkColumn, ReportStatistics statistics) {
        SubRenderer subRenderer = this.getSubRenderer();
        ConfluenceEntityObject ceo = content.getEntity();
        AbstractPage page = ceo instanceof AbstractPage ? (AbstractPage)ceo : null;
        for (int i = 0; i < columns.length; ++i) {
            if (i > 0) {
                html.append(" ");
            }
            String column = columns[i];
            MetadataValue value = content.getMetadataValue(column);
            String valueString = this.metadataValueRenderer.renderSingleValue(html, renderContext, linkColumn, subRenderer, ceo, page, column, value);
            statistics.recordValue(i, valueString);
        }
    }
}

