/*
 * Decompiled with CFR 0.152.
 */
package org.andya.confluence.plugins.metadata.model;

import com.atlassian.confluence.core.ConfluenceEntityObject;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.andya.confluence.plugins.metadata.MetadataUtils;
import org.andya.confluence.plugins.metadata.model.MetadataValue;
import org.andya.confluence.utils.ContentService;

public class MetadataContent {
    private final ContentService contentService;
    private final ConfluenceEntityObject entity;
    private final Map<String, MetadataValue> values = new HashMap<String, MetadataValue>();

    public MetadataContent(ContentService contentService, ConfluenceEntityObject entity) {
        this.contentService = contentService;
        this.entity = entity;
    }

    public ContentService getContentService() {
        return this.contentService;
    }

    public ConfluenceEntityObject getEntity() {
        return this.entity;
    }

    public void putMetadataValue(MetadataValue value) {
        this.values.put(value.getName(), value);
    }

    public MetadataValue getMetadataValue(String name) {
        return this.getMetadataValue(name, null);
    }

    public MetadataValue getMetadataValue(String name, Object defaultValue) {
        Map<String, MetadataValue> values = this.values;
        ContentService contentService = this.getContentService();
        if (values.containsKey(name)) {
            MetadataValue value = values.get(name);
            if (value != null) {
                return value;
            }
        } else {
            MetadataValue value;
            ConfluenceEntityObject entity = this.getEntity();
            if (contentService != null && entity != null && (value = MetadataUtils.getMetadataValue(contentService, entity, name, null)) != null) {
                this.putMetadataValue(value);
                return value;
            }
        }
        return contentService.createMetadataValue(name, null, defaultValue);
    }

    public Number getMetadataNumber(String name) {
        return this.getMetadataNumber(name, null);
    }

    public Number getMetadataNumber(String name, Number defaultValue) {
        MetadataValue value = this.getMetadataValue(name);
        return value != null ? (Number)value.getValueAsNumber() : (Number)defaultValue;
    }

    public Date getMetadataDate(String name) {
        MetadataValue value = this.getMetadataValue(name);
        return value != null ? value.getValueAsDate() : null;
    }

    public String getMetadataWikiSnippet(String name) {
        return this.getMetadataWikiSnippet(name, "");
    }

    public String getMetadataWikiSnippet(String name, String defaultSnippet) {
        MetadataValue value = this.getMetadataValue(name);
        return value != null ? value.getWikiSnippet() : defaultSnippet;
    }

    public String toString() {
        return "MetadataContent{ceo=" + this.getEntity() + "}";
    }
}

