/*
 * Decompiled with CFR 0.152.
 */
package org.andya.confluence.utils.page;

import com.atlassian.confluence.api.service.search.CQLSearchService;
import com.atlassian.confluence.labels.LabelManager;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.v2.macro.MacroException;
import java.util.Map;
import org.andya.confluence.utils.MacroConstants;
import org.andya.confluence.utils.MacroUtils;
import org.apache.commons.lang3.StringUtils;

public class PageSearchContext
implements MacroConstants {
    private final Map parameters;
    private final LabelManager labelManager;
    private final String spaceKey;
    private final RenderContext renderContext;
    private final PageManager pageManager;
    private final PermissionManager permissionManager;
    private final CQLSearchService cqlSearchService;
    private final int maxResults;

    public PageSearchContext(Map parameters, LabelManager labelManager, RenderContext renderContext, PageManager pageManager, PermissionManager permissionManager, CQLSearchService cqlSearchService, int maxResults) throws MacroException {
        this.parameters = parameters;
        this.labelManager = labelManager;
        this.renderContext = renderContext;
        this.pageManager = pageManager;
        this.permissionManager = permissionManager;
        this.cqlSearchService = cqlSearchService;
        String spaceKey = this.getStringParameter("space", "");
        if (StringUtils.isBlank((CharSequence)spaceKey)) {
            spaceKey = this.getStringParameter("key", "");
        }
        this.spaceKey = spaceKey;
        this.maxResults = maxResults;
    }

    public LabelManager getLabelManager() {
        return this.labelManager;
    }

    public String getSpaceKey() {
        return this.spaceKey;
    }

    public String getStringParameter(String name, boolean required) throws MacroException {
        return MacroUtils.getStringParameter(this.parameters, name, required);
    }

    public String getStringParameter(String name, String defaultValue) throws MacroException {
        return MacroUtils.getStringParameter(this.parameters, name, defaultValue);
    }

    public RenderContext getRenderContext() {
        return this.renderContext;
    }

    public PageManager getPageManager() {
        return this.pageManager;
    }

    public boolean hasParameter(String key) {
        return this.parameters.containsKey(key);
    }

    void setParameter(String key, String value) {
        this.parameters.put(key, value);
    }

    public PermissionManager getPermissionManager() {
        return this.permissionManager;
    }

    public CQLSearchService getCqlSearchService() {
        return this.cqlSearchService;
    }

    public int getMaxResults() {
        return this.maxResults;
    }
}

