/*
 * Decompiled with CFR 0.152.
 */
package org.andya.confluence.utils;

import com.atlassian.confluence.core.ConfluenceEntityObject;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.DateFormatter;
import com.atlassian.confluence.core.FormatSettingsManager;
import com.atlassian.confluence.languages.LocaleManager;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.BlogPost;
import com.atlassian.confluence.pages.Comment;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceDescription;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.PersonalInformation;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.confluence.util.ExcerptHelper;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.spring.container.ContainerManager;
import com.atlassian.user.User;
import com.atlassian.user.UserManager;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.andya.confluence.plugins.metadata.content.ComalaPropertiesSetManager;
import org.andya.confluence.plugins.metadata.model.MetadataValue;
import org.andya.confluence.plugins.metadata.space.SpaceUtils;
import org.andya.confluence.utils.ContentUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ContentService {
    private static final Logger log = LoggerFactory.getLogger(ContentService.class);
    private static final String METADATA_MACRO_START = "<ac:structured-macro ac:name=\"metadata\"";
    private static final String METADATA_MACRO_END = "</ac:structured-macro>";
    private static final String METADATA_MACRO_PARAM_START = "<ac:parameter ac:name=\"0\">";
    private static final String METADATA_MACRO_PARAM_END = "</ac:parameter>";
    public static final String ATTACHMENT_KEY = "Attachment";
    public static final String AUTHOR_KEY = "Author";
    public static final String BLOG_POST_KEY = "Blog Post";
    public static final String COMMENT_KEY = "Comment";
    public static final String COMMENTS_KEY = "Comments";
    public static final String CREATOR_KEY = "Creator";
    public static final String DATE_KEY = "Date";
    public static final String DISPLAY_TITLE_KEY = "DisplayTitle";
    public static final String DOWNLOAD_KEY = "Download";
    public static final String EMAIL_KEY = "Email";
    public static final String EXCERPT_KEY = "Excerpt";
    public static final String FILE_SIZE_KEY = "File Size";
    public static final String FILE_TYPE_KEY = "File Type";
    public static final String LAST_CHANGED_BY_KEY = "Last Changed By";
    public static final String LAST_TIME_CHANGED_KEY = "Last Time Changed";
    public static final String PAGE_KEY = "Page";
    public static final String PARENT_KEY = "Parent";
    public static final String POSTED_KEY = "Posted";
    public static final String POSTER_KEY = "Poster";
    public static final String SIZE_KEY = "Size";
    public static final String SPACE_KEY = "Space";
    public static final String TIME_KEY = "Time";
    public static final String TIME_CREATED_KEY = "Time Created";
    public static final String TITLE_KEY = "Title";
    public static final String TYPE_KEY = "Type";
    public static final String USER_KEY = "User";
    public static final String VERSION_KEY = "Version";
    private final ComalaPropertiesSetManager contentPropertyManager;
    private final SpaceManager spaceManager;
    private final UserManager userManager;
    private final FormatSettingsManager formatSettingsManager;
    private final LocaleManager localeManager;
    private final ExcerptHelper excerptHelper;

    public ContentService(ComalaPropertiesSetManager contentPropertyManager, @ComponentImport SpaceManager spaceManager, @ComponentImport UserManager userManager, @ComponentImport FormatSettingsManager formatSettingsManager, @ComponentImport LocaleManager localeManager) {
        this.contentPropertyManager = contentPropertyManager;
        this.spaceManager = spaceManager;
        this.userManager = userManager;
        this.formatSettingsManager = formatSettingsManager;
        this.localeManager = localeManager;
        this.excerptHelper = (ExcerptHelper)ContainerManager.getComponent((String)"excerptHelper");
    }

    public ComalaPropertiesSetManager getContentPropertyManager() {
        return this.contentPropertyManager;
    }

    public SpaceManager getSpaceManager() {
        return this.spaceManager;
    }

    public LocaleManager getLocaleManager() {
        return this.localeManager;
    }

    public Object getContentValue(ConfluenceEntityObject ceo, String valueName) {
        DateFormatter dateFormatter = this.getDateFormatter();
        if (AUTHOR_KEY.equals(valueName) || CREATOR_KEY.equals(valueName) || POSTER_KEY.equals(valueName)) {
            return ContentUtils.getUserLink(ceo.getCreator() != null ? ceo.getCreator().getName() : null);
        }
        if (LAST_CHANGED_BY_KEY.equals(valueName)) {
            return ContentUtils.getUserLink(ceo.getLastModifier() != null ? ceo.getLastModifier().getName() : null);
        }
        if (LAST_TIME_CHANGED_KEY.equals(valueName)) {
            return ceo.getLastModificationDate();
        }
        if (DATE_KEY.equals(valueName)) {
            Date date = ceo.getLastModificationDate();
            return new MetadataValue(valueName, date, dateFormatter.format(date));
        }
        if (TIME_KEY.equals(valueName)) {
            Date date = ceo.getLastModificationDate();
            return new MetadataValue(valueName, date, dateFormatter.formatTime(date));
        }
        if (TIME_CREATED_KEY.equals(valueName) || POSTED_KEY.equals(valueName)) {
            return ceo.getCreationDate();
        }
        if (ceo instanceof ContentEntityObject) {
            ContentEntityObject c = (ContentEntityObject)ceo;
            if (EXCERPT_KEY.equals(valueName)) {
                return this.excerptHelper.getExcerpt(c);
            }
        }
        if (ceo instanceof Page) {
            Page page = (Page)ceo;
            if (TITLE_KEY.equals(valueName) || PAGE_KEY.equals(valueName)) {
                return ContentUtils.getPageLink(page);
            }
            if (DISPLAY_TITLE_KEY.equals(valueName)) {
                return page.getTitle();
            }
            if (SPACE_KEY.equals(valueName)) {
                Space space = page.getSpace();
                return ContentUtils.getSpaceLink(space);
            }
            if (PARENT_KEY.equals(valueName)) {
                Page parent = page.getParent();
                if (parent != null) {
                    return ContentUtils.getPageLink(parent);
                }
            } else if (VERSION_KEY.equals(valueName)) {
                return page.getVersion();
            }
        } else if (ceo instanceof BlogPost) {
            BlogPost blogPost = (BlogPost)ceo;
            if (TITLE_KEY.equals(valueName) || BLOG_POST_KEY.equals(valueName)) {
                return ContentUtils.getBlogPostLink(blogPost);
            }
            if (DISPLAY_TITLE_KEY.equals(valueName)) {
                return blogPost.getTitle();
            }
            if (SPACE_KEY.equals(valueName)) {
                Space space = blogPost.getSpace();
                return ContentUtils.getSpaceLink(space);
            }
            if (COMMENTS_KEY.equals(valueName)) {
                List comments = blogPost.getComments();
                if (comments.size() == 0) {
                    return ContentUtils.getBlogpostCommentsLink(0, blogPost);
                }
                return ContentUtils.getCommentLink(comments.size(), (Comment)comments.get(0));
            }
            if (VERSION_KEY.equals(valueName)) {
                return blogPost.getVersion();
            }
        } else if (ceo instanceof SpaceDescription) {
            SpaceDescription spaceDescription = (SpaceDescription)ceo;
            Space space = spaceDescription.getSpace();
            if (SPACE_KEY.equals(valueName) || TITLE_KEY.equals(valueName)) {
                return ContentUtils.getSpaceLink(space);
            }
            if (PARENT_KEY.equals(valueName)) {
                Space parentSpace = SpaceUtils.getParentSpace(this, space);
                if (parentSpace != null) {
                    return ContentUtils.getSpaceLink(parentSpace);
                }
            } else {
                if (USER_KEY.equals(valueName)) {
                    return ContentUtils.getUserLink(ceo.getCreator() != null ? ceo.getCreator().getName() : null);
                }
                if (EMAIL_KEY.equals(valueName) && space.isPersonal()) {
                    User user = SpaceUtils.getPersonalSpaceOwner(this.userManager, space);
                    if (user != null) {
                        return ContentUtils.getEmailLink(user);
                    }
                } else if (LAST_TIME_CHANGED_KEY.equals(valueName)) {
                    return space.getLastModificationDate();
                }
            }
        } else if (ceo instanceof PersonalInformation) {
            PersonalInformation personalInformation = (PersonalInformation)ceo;
            if (USER_KEY.equals(valueName)) {
                return ContentUtils.getUserLink(personalInformation.getUser() != null ? personalInformation.getUser().getName() : null);
            }
            if (EMAIL_KEY.equals(valueName)) {
                String email;
                String string = email = personalInformation.getUser() != null ? personalInformation.getUser().getEmail() : null;
                if (!StringUtils.isBlank((String)email)) {
                    return ContentUtils.getEmailLink(email);
                }
            }
        } else if (ceo instanceof Attachment) {
            Attachment attachment = (Attachment)ceo;
            int version = attachment.getVersion();
            if (ATTACHMENT_KEY.equals(valueName)) {
                return ContentUtils.getAttachmentLink(attachment);
            }
            if (TITLE_KEY.equals(valueName) || COMMENT_KEY.equals(valueName)) {
                return ContentUtils.getAttachmentLink(attachment, attachment.getVersionComment());
            }
            if (FILE_SIZE_KEY.equals(valueName) || SIZE_KEY.equals(valueName)) {
                return new MetadataValue(valueName, attachment.getFileSize(), attachment.getNiceFileSize());
            }
            if (FILE_TYPE_KEY.equals(valueName) || TYPE_KEY.equals(valueName)) {
                return attachment.getNiceType();
            }
            if (DOWNLOAD_KEY.equals(valueName)) {
                return ContentUtils.getAttachmentLink(attachment, attachment.getDisplayTitle());
            }
            if (VERSION_KEY.equals(valueName)) {
                return ContentUtils.getAttachmentLink(attachment, attachment.getDisplayTitle()) + " (" + version + ")";
            }
        }
        return null;
    }

    public MetadataValue createMetadataValue(String name, Object value) {
        return this.createMetadataValue(name, value, null);
    }

    public MetadataValue createMetadataValue(String name, Object value, Object defaultValue) {
        if (value == null) {
            if (defaultValue == null) {
                return null;
            }
            value = defaultValue;
        }
        return new MetadataValue(name, value, this.createWikiSnippet(value));
    }

    public String createWikiSnippet(Object value) {
        if (value instanceof Date) {
            return this.getDateForUser((Date)value);
        }
        return value != null ? value.toString() : "";
    }

    public DateFormatter getDateFormatter() {
        UserAccessor userAccessor = (UserAccessor)ContainerManager.getComponent((String)"userAccessor");
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        return userAccessor.getConfluenceUserPreferences((User)user).getDateFormatter(this.formatSettingsManager, this.getLocaleManager());
    }

    public String getDateForUser(Date date) {
        DateFormatter dateFormatter = this.getDateFormatter();
        return dateFormatter.formatDateTime(date);
    }

    public List<String> getMetadataMacroNamesFromPage(AbstractPage page) {
        int pos;
        String body = page.getBodyAsString();
        ArrayList<String> macros = new ArrayList<String>();
        int index = 0;
        while (index < body.length() && (pos = body.indexOf(METADATA_MACRO_START, index)) > -1) {
            index = body.indexOf(METADATA_MACRO_END, pos) + METADATA_MACRO_END.length();
            macros.add(body.substring(pos, index));
        }
        return macros.stream().map(macro -> {
            int nameStart = macro.indexOf(METADATA_MACRO_PARAM_START) + METADATA_MACRO_PARAM_START.length();
            int nameEnd = macro.indexOf(METADATA_MACRO_PARAM_END);
            return macro.substring(nameStart, nameEnd);
        }).collect(Collectors.toList());
    }
}

