/*
 * Decompiled with CFR 0.152.
 */
package org.andya.confluence.plugins.metadata.users;

import com.atlassian.confluence.core.ConfluenceEntityObject;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.PersonalInformationManager;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.Query;
import com.atlassian.crowd.embedded.api.SearchRestriction;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.builder.Restriction;
import com.atlassian.crowd.search.query.entity.EntityQuery;
import com.atlassian.crowd.search.query.entity.restriction.Property;
import com.atlassian.crowd.search.query.entity.restriction.PropertyRestriction;
import com.atlassian.crowd.search.query.entity.restriction.constants.UserTermKeys;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.v2.RenderMode;
import com.atlassian.renderer.v2.macro.MacroException;
import com.atlassian.user.User;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.andya.confluence.plugins.metadata.model.MetadataContent;
import org.andya.confluence.plugins.metadata.renderers.MetadataRenderer;
import org.andya.confluence.plugins.metadata.space.AbstractSpaceMetadataMacro;
import org.andya.confluence.utils.MacroUtils;

public class UsersReportMacro
extends AbstractSpaceMetadataMacro {
    @ComponentImport
    private PersonalInformationManager personalInformationManager;
    @ComponentImport
    private CrowdService crowdService;
    @ComponentImport
    private UserAccessor userAccessor;

    public UsersReportMacro() {
        super("users-report");
    }

    public boolean isInline() {
        return true;
    }

    public boolean hasBody() {
        return false;
    }

    public RenderMode getBodyRenderMode() {
        return RenderMode.NO_RENDER;
    }

    @Override
    public String doExecute(Map parameters, String body, RenderContext renderContext) throws MacroException {
        try {
            List<ConfluenceEntityObject> usersMetadata = this.getUsersMetadata(this.getSystemMaxResultsForUsers());
            List<MetadataContent> sortedContents = this.getSortedContents(parameters, usersMetadata, "User");
            return this.renderUsersReport(parameters, renderContext, sortedContents);
        }
        catch (Exception e) {
            return MacroUtils.showRenderedExceptionString(parameters, "Unable to render macro", e.getMessage());
        }
    }

    private String renderUsersReport(Map parameters, RenderContext renderContext, List<MetadataContent> users) throws MacroException {
        String commaDelimitedColumns = MacroUtils.getStringParameter(parameters, "0", true);
        String[] columns = commaDelimitedColumns.split(",");
        String commaDelimitedTotals = MacroUtils.getStringParameter(parameters, "totals", "");
        MetadataRenderer renderer = this.getMetadataRenderer(parameters);
        return renderer.render(renderContext, users, this.getMaxResultsForUsers(parameters), columns, commaDelimitedTotals, "User", this.getI18nResolver());
    }

    private List<ConfluenceEntityObject> getUsersMetadata(int maxResults) {
        ArrayList<ConfluenceEntityObject> usersMetadata = new ArrayList<ConfluenceEntityObject>();
        PropertyRestriction restriction = Restriction.on((Property)UserTermKeys.ACTIVE).containing((Object)true);
        EntityQuery query = QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.user()).with((SearchRestriction)restriction).returningAtMost(maxResults);
        Iterable usernames = this.crowdService.search((Query)query);
        for (String username : usernames) {
            ConfluenceEntityObject userMetadata = this.getUserMetadata(this.userAccessor.getUserByName(username));
            if (userMetadata == null) continue;
            usersMetadata.add(userMetadata);
        }
        if (usersMetadata.size() >= maxResults) {
            reportLimitHitFlag.set(true);
        }
        return usersMetadata;
    }

    @Nullable
    private ConfluenceEntityObject getUserMetadata(ConfluenceUser user) {
        Space personalSpace = this.getSpaceManager().getPersonalSpace(user);
        if (personalSpace != null) {
            return personalSpace.getDescription();
        }
        return this.personalInformationManager.getOrCreatePersonalInformation((User)user);
    }

    public PersonalInformationManager getPersonalInformationManager() {
        return this.personalInformationManager;
    }

    public void setPersonalInformationManager(PersonalInformationManager personalInformationManager) {
        this.personalInformationManager = personalInformationManager;
    }

    public CrowdService getCrowdService() {
        return this.crowdService;
    }

    public void setCrowdService(CrowdService crowdService) {
        this.crowdService = crowdService;
    }

    public UserAccessor getUserAccessor() {
        return this.userAccessor;
    }

    public void setUserAccessor(UserAccessor userAccessor) {
        this.userAccessor = userAccessor;
    }
}

