/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.analytics;

import com.atlassian.plugin.web.model.WebPanel;
import com.comalatech.confluence.analytics.AnalyticsManager;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;

public class AnalyticsWebPanel
implements WebPanel {
    private AnalyticsManager analyticsManager;

    public AnalyticsWebPanel(AnalyticsManager analyticsManager) {
        this.analyticsManager = analyticsManager;
    }

    public String getHtml(Map<String, Object> context) {
        String pluginKey = this.analyticsManager.getPrefix().replaceAll("-", "");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("trace", this.analyticsManager.isDebugEnabled() + "");
        params.put("dev-mode", this.analyticsManager.isDevMode() + "");
        if (this.analyticsManager.hasStats()) {
            this.analyticsManager.popStats().entrySet().stream().forEach(entry -> params.put("stats-" + (String)entry.getKey(), entry.getValue().toString()));
        }
        return this.stringifyAjsMap(params, pluginKey);
    }

    public void writeHtml(Writer writer, Map<String, Object> context) throws IOException {
        writer.write(this.getHtml(context));
    }

    private String stringifyAjsMap(Map<String, String> map, String prefix) {
        return map.entrySet().stream().map(entry -> "<meta name=\"ajs-" + (prefix != null ? prefix + "-" : "") + (String)entry.getKey() + "\" content=\"" + (String)entry.getValue() + "\" />").collect(Collectors.joining());
    }
}

