/*
 * Decompiled with CFR 0.152.
 */
package org.andya.confluence.utils.page.resolver;

import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.v2.macro.MacroException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.andya.confluence.utils.page.resolver.TitlePageResolverImpl;
import org.andya.confluence.utils.page.resolver.contract.PageResolver;

public class SpacePageResolverImpl
extends TitlePageResolverImpl
implements PageResolver {
    public SpacePageResolverImpl(PageManager pageManager) {
        super(pageManager);
    }

    @Override
    public Page resolve(String value, RenderContext renderContext, String spaceKey) throws MacroException {
        try {
            return super.resolve(value, renderContext, spaceKey);
        }
        catch (MacroException macroException) {
            Pattern spacePagePattern = Pattern.compile("^(?<spaceKey>[^:]+):(?<pageTitle>.+)");
            Matcher matcher = spacePagePattern.matcher(value);
            if (matcher.find()) {
                String pageTitle;
                String customSpaceKey = matcher.group("spaceKey");
                Page resolvedPage = this.pageManager.getPage(customSpaceKey, pageTitle = matcher.group("pageTitle"));
                if (resolvedPage == null) {
                    throw new MacroException("No such page " + pageTitle + " on the space key " + customSpaceKey);
                }
                return resolvedPage;
            }
            throw new MacroException("Space page pattern is not correct and cannot find a page: " + value);
        }
    }
}

