/*
 * Decompiled with CFR 0.152.
 */
package org.andya.confluence.utils;

import com.atlassian.core.util.DateUtils;
import com.atlassian.core.util.InvalidDurationException;

public class Duration
extends Number {
    private static final long serialVersionUID = -91792353858202089L;
    private final long duration;

    public Duration(long duration) {
        this.duration = duration;
    }

    public static Duration parseDuration(String durationString) {
        if (!Duration.isDuration(durationString)) {
            return null;
        }
        durationString = durationString.trim();
        try {
            long duration = DateUtils.getDuration((String)durationString);
            return new Duration(duration);
        }
        catch (InvalidDurationException e) {
            return null;
        }
    }

    public static boolean isDuration(String durationString) {
        int durationLength = (durationString = durationString.trim()).length();
        if (durationLength == 0) {
            return false;
        }
        char lastChar = durationString.charAt(durationLength - 1);
        return "mhdw".contains(String.valueOf(lastChar));
    }

    public String getDurationString() {
        return DateUtils.getDurationStringWithNegative((long)this.longValue());
    }

    @Override
    public double doubleValue() {
        return this.duration;
    }

    @Override
    public float floatValue() {
        return this.duration;
    }

    @Override
    public int intValue() {
        return (int)this.duration;
    }

    @Override
    public long longValue() {
        return this.duration;
    }

    public boolean equals(Object object) {
        if (object instanceof Duration) {
            return this.longValue() == ((Duration)object).longValue();
        }
        return false;
    }

    public int hashCode() {
        return this.intValue();
    }

    public String toString() {
        return this.getDurationString();
    }
}

