/*
 * Decompiled with CFR 0.152.
 */
package org.andya.confluence.plugins.metadata.space;

import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.andya.confluence.plugins.metadata.space.SpaceDetails;
import org.andya.confluence.plugins.metadata.space.SpaceUtils;
import org.andya.confluence.utils.ContentService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpaceHierarchyService {
    private static final Logger log = LoggerFactory.getLogger(SpaceHierarchyService.class);
    private final ContentService contentService;
    private final SpaceManager spaceManager;
    private SpaceDetails userSpaceDetails;

    public SpaceHierarchyService(ContentService contentService, SpaceManager spaceManager) {
        this.contentService = contentService;
        this.spaceManager = spaceManager;
    }

    public SpaceDetails buildParentHierarchy(String spaceKey) {
        return this.buildParentHierarchy(spaceKey, new ArrayList<String>());
    }

    private SpaceDetails buildParentHierarchy(String spaceKey, List<String> processed) {
        Space space = this.spaceManager.getSpace(spaceKey);
        if (space == null) {
            return new SpaceDetails(null, null, null);
        }
        SpaceDetails spaceDetails = new SpaceDetails(spaceKey, space.getName(), space.getUrlPath());
        Space parent = SpaceUtils.getParentSpace(this.contentService, space);
        String parentKey = null;
        if (parent == null && space.isPersonal() && this.userSpaceDetails != null) {
            parentKey = this.userSpaceDetails.getSpaceKey();
        }
        if (parentKey == null && parent != null) {
            parentKey = parent.getKey();
        }
        if (processed.contains(parentKey)) {
            log.error("Space " + parentKey + " is already in the hierarchy and won't be set as parent of " + spaceKey + ". Review the hierarchy to prevent loops. This space hierarchy me be incomplete.");
            return spaceDetails;
        }
        if (parent != null) {
            processed.add(parentKey);
        }
        spaceDetails.setParent(this.buildParentHierarchy(parentKey, processed));
        if (SpaceUtils.isUsersSpace(this.contentService, space)) {
            this.userSpaceDetails = spaceDetails;
        }
        return spaceDetails;
    }

    public SpaceDetails buildChildrenHierarchy(String spaceKey, List<Space> spaces) {
        HashMap<String, String> parentsMap = new HashMap<String, String>();
        spaces.stream().forEach(space -> {
            Space parent = SpaceUtils.getParentSpace(this.contentService, space);
            if (parent != null) {
                parentsMap.put(space.getKey(), parent.getKey());
            }
        });
        HashMap<String, List<String>> childrenMap = new HashMap<String, List<String>>();
        this.processChild(childrenMap, parentsMap, spaceKey);
        return this.buildChildrenHierarchy(spaceKey, childrenMap, new ArrayList<String>());
    }

    private void processChild(Map<String, List<String>> childrenMap, Map<String, String> parentsMap, String spaceKey) {
        List<String> childrenKeys = this.findChildren(spaceKey, parentsMap);
        if (!childrenMap.containsKey(spaceKey)) {
            childrenMap.put(spaceKey, childrenKeys);
            childrenKeys.stream().forEach(key -> this.processChild(childrenMap, parentsMap, (String)key));
        }
    }

    private List<String> findChildren(String spaceKey, Map<String, String> parentsMap) {
        return parentsMap.entrySet().stream().filter(entry -> spaceKey.equals(entry.getValue())).map(entry -> (String)entry.getKey()).collect(Collectors.toList());
    }

    private SpaceDetails buildChildrenHierarchy(String spaceKey, Map<String, List<String>> childrenMap, List<String> processed) {
        SpaceDetails spaceDetails;
        if (processed.contains(spaceKey)) {
            log.error("Space " + spaceKey + " is already in the hierarchy and won't be added again. Review the hierarchy to prevent loops. This space hierarchy me be incomplete.");
            spaceDetails = null;
        } else {
            Space space = this.spaceManager.getSpace(spaceKey);
            if (space != null) {
                processed.add(spaceKey);
                spaceDetails = new SpaceDetails(spaceKey, space.getName(), space.getUrlPath());
                List<String> children = childrenMap.get(spaceKey);
                children.stream().forEach(child -> {
                    SpaceDetails childHierarchy = this.buildChildrenHierarchy((String)child, childrenMap, processed);
                    if (childHierarchy != null) {
                        spaceDetails.addChildren(childHierarchy);
                    }
                });
            } else {
                spaceDetails = new SpaceDetails(null, null, null);
            }
        }
        return spaceDetails;
    }
}

