/*
 * Decompiled with CFR 0.152.
 */
package org.andya.confluence.plugins.metadata.space;

import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.security.Permission;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.v2.RenderMode;
import com.atlassian.renderer.v2.components.HtmlEscaper;
import com.atlassian.renderer.v2.macro.MacroException;
import com.atlassian.user.User;
import java.util.Map;
import org.andya.confluence.plugins.metadata.AbstractMetadataMacro;
import org.andya.confluence.plugins.metadata.MetadataUtils;
import org.andya.confluence.plugins.metadata.space.AbstractSpaceMetadataMacro;
import org.andya.confluence.plugins.metadata.space.SpaceDetails;
import org.andya.confluence.plugins.metadata.space.SpaceHierarchyService;
import org.andya.confluence.utils.ContentUtils;
import org.andya.confluence.utils.MacroUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;

public class SpaceBreadcrumbsMacro
extends AbstractSpaceMetadataMacro
implements InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(SpaceBreadcrumbsMacro.class);
    public static final String SHOW_DASHBOARD_AND_HOME = "dashboard+home";
    public static final String SHOW_DASHBOARD_ONLY = "dashboard";
    public static final String SHOW_HOME_ONLY = "home";
    private SpaceHierarchyService hierarchyService;

    public SpaceBreadcrumbsMacro() {
        super("space-breadcrumbs");
    }

    public boolean hasBody() {
        return false;
    }

    public RenderMode getBodyRenderMode() {
        return RenderMode.NO_RENDER;
    }

    @Override
    public String doExecute(Map parameters, String body, RenderContext renderContext) throws MacroException {
        try {
            String pageName = MacroUtils.getStringParameter(parameters, "0", "@self");
            Page page = this.getPage(renderContext, pageName, false);
            if (this.getPermissionManager().hasPermission((User)this.getUser(), Permission.VIEW, (Object)page)) {
                boolean isHome;
                String title;
                String spaceKey;
                boolean showHome;
                String show = MacroUtils.getStringParameter(parameters, "1", false);
                boolean showDashboard = SHOW_DASHBOARD_AND_HOME.equals(show) || SHOW_DASHBOARD_ONLY.equals(show);
                boolean bl = showHome = SHOW_DASHBOARD_AND_HOME.equals(show) || SHOW_HOME_ONLY.equals(show);
                if (page != null) {
                    spaceKey = page.getSpace().getKey();
                    title = page.getTitle();
                    isHome = ContentUtils.isHomePage(page);
                } else {
                    String[] pageSections = pageName.split(":");
                    spaceKey = pageSections[0];
                    title = pageSections[1];
                    isHome = false;
                }
                SpaceDetails hierarchyDetails = this.hierarchyService.buildParentHierarchy(spaceKey);
                StringBuilder html = new StringBuilder();
                if (BooleanUtils.isTrue((Boolean)AbstractMetadataMacro.reportLimitHitFlag.get())) {
                    html.append(MetadataUtils.getPageLimitMessage("Space", this.getI18nResolver()));
                }
                html.append("<span class=\"topBarDiv\">");
                if (showDashboard) {
                    html.append("<a href=\"/dashboard.action\">Dashboard</a> &gt; ");
                }
                this.writeSpaceBreadcrumbs(html, hierarchyDetails, !isHome || showHome, renderContext);
                if (!isHome || showHome) {
                    if (page != null) {
                        this.writePageBreadcrumbs(html, page, false, showHome, renderContext);
                    } else {
                        html.append(title);
                    }
                }
                html.append("</span>");
                return html.toString();
            }
        }
        catch (Exception e) {
            return MacroUtils.showRenderedExceptionString(parameters, "Unable to render macro", e);
        }
        return "";
    }

    private void writeSpaceBreadcrumbs(StringBuilder html, SpaceDetails hierarchyDetails, boolean linkSpace, RenderContext renderContext) throws MacroException {
        if (hierarchyDetails != null) {
            SpaceDetails parentDetails = hierarchyDetails.getParent();
            if (parentDetails != null) {
                this.writeSpaceBreadcrumbs(html, parentDetails, true, renderContext);
            }
            if (hierarchyDetails.getSpaceKey() != null) {
                if (linkSpace) {
                    html.append("<a href='");
                    html.append(renderContext.getSiteRoot()).append(hierarchyDetails.getUrlPath());
                    html.append("'>");
                }
                html.append(HtmlEscaper.escapeAll((String)hierarchyDetails.getName(), (boolean)true));
                if (linkSpace) {
                    html.append("</a>");
                    html.append(" &gt; ");
                }
            }
        }
    }

    private void writePageBreadcrumbs(StringBuilder html, Page page, boolean linkPage, boolean showHome, RenderContext renderContext) {
        if (!showHome && ContentUtils.isHomePage(page)) {
            return;
        }
        Page parentPage = page.getParent();
        if (parentPage != null) {
            this.writePageBreadcrumbs(html, parentPage, true, false, renderContext);
        }
        if (linkPage) {
            html.append("<a href='");
            html.append(renderContext.getSiteRoot()).append(page.getUrlPath());
            html.append("'>");
        }
        html.append(HtmlEscaper.escapeAll((String)page.getTitle(), (boolean)true));
        if (linkPage) {
            html.append("</a>");
            html.append(" &gt; ");
        }
    }

    public void afterPropertiesSet() throws Exception {
        this.hierarchyService = new SpaceHierarchyService(this.getContentService(), this.getSpaceManager());
    }
}

