/*
 * Decompiled with CFR 0.152.
 */
package org.andya.confluence.plugins.metadata.space;

import com.atlassian.confluence.core.ConfluenceEntityObject;
import com.atlassian.confluence.labels.Label;
import com.atlassian.confluence.labels.LabelParser;
import com.atlassian.confluence.labels.Namespace;
import com.atlassian.confluence.labels.ParsedLabelName;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceDescription;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.v2.RenderMode;
import com.atlassian.renderer.v2.macro.MacroException;
import com.atlassian.user.User;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.andya.confluence.plugins.metadata.model.MetadataContent;
import org.andya.confluence.plugins.metadata.renderers.MetadataRenderer;
import org.andya.confluence.plugins.metadata.space.AbstractSpaceMetadataMacro;
import org.andya.confluence.utils.MacroUtils;

public class SpacesReportMacro
extends AbstractSpaceMetadataMacro {
    public SpacesReportMacro() {
        super("space-report");
    }

    public boolean isInline() {
        return true;
    }

    public boolean hasBody() {
        return true;
    }

    public RenderMode getBodyRenderMode() {
        return RenderMode.NO_RENDER;
    }

    @Override
    public String doExecute(Map parameters, String body, RenderContext renderContext) throws MacroException {
        try {
            String commaDelimitedColumns = MacroUtils.getStringParameter(parameters, "0", true);
            List<MetadataContent> contents = this.getMatchingSpaces(parameters, true);
            String[] columns = commaDelimitedColumns.split(",");
            String commaDelimitedTotals = MacroUtils.getStringParameter(parameters, "totals", "");
            MetadataRenderer renderer = this.getMetadataRenderer(parameters);
            return renderer.render(renderContext, contents, this.getMaxResultsForSpaces(parameters), columns, commaDelimitedTotals, "Space", this.getI18nResolver());
        }
        catch (Exception e) {
            return MacroUtils.showRenderedExceptionString(parameters, "Unable to render macro", e.getMessage());
        }
    }

    public List<MetadataContent> getMatchingSpaces(Map parameters, boolean ordered) throws MacroException {
        List<Space> spaces = this.findSpacesForCurrentUser(this.getSystemMaxResultsForSpaces());
        spaces = this.applyFilters(parameters, spaces);
        ArrayList<ConfluenceEntityObject> allowedSpaceDescriptions = new ArrayList<ConfluenceEntityObject>();
        for (Space space : spaces) {
            SpaceDescription spaceDescription = space.getDescription();
            allowedSpaceDescriptions.add((ConfluenceEntityObject)spaceDescription);
        }
        return this.getSortedContents(parameters, allowedSpaceDescriptions, ordered ? "Space" : null);
    }

    private List<Space> applyFilters(Map parameters, List<Space> spaces) throws MacroException {
        ParsedLabelName parsedLabelName;
        String type = MacroUtils.getStringParameter(parameters, "type", null);
        String labelName = MacroUtils.getStringParameter(parameters, "label", null);
        boolean personalOnlyFilter = "personal".equalsIgnoreCase(type);
        ParsedLabelName parsedLabelName2 = parsedLabelName = labelName != null ? LabelParser.parse((String)labelName, (User)AuthenticatedUserThreadLocal.get()) : null;
        Label labelFilter = parsedLabelName != null ? this.getLabelManager().getLabel(parsedLabelName.getName(), personalOnlyFilter ? Namespace.PERSONAL : Namespace.TEAM) : null;
        return spaces.stream().filter(space -> !personalOnlyFilter || space.isPersonal()).filter(space -> labelFilter == null || this.getSpaceLabelManager().getTeamLabelsOnSpace(space.getKey()).contains(labelFilter)).collect(Collectors.toList());
    }
}

