/*
 * Decompiled with CFR 0.152.
 */
package org.andya.confluence.plugins.metadata.model;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Objects;
import org.andya.confluence.plugins.metadata.aop.HtmlEncoding;
import org.andya.confluence.plugins.metadata.aop.HtmlEncodingAspect;
import org.andya.confluence.utils.MathUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;

public class MetadataValue
implements Comparable<MetadataValue> {
    private final String name;
    private final Object value;
    private final String wikiSnippet;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;

    public MetadataValue(String name, Object value, String wikiSyntax) {
        this.name = name;
        this.value = value;
        this.wikiSnippet = wikiSyntax;
    }

    public MetadataValue(String name, String wikiSyntax) {
        this.name = name;
        this.value = wikiSyntax;
        this.wikiSnippet = wikiSyntax;
    }

    public String getName() {
        return this.name;
    }

    @HtmlEncoding
    public Object getValue() {
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_0, this, this);
        return MetadataValue.getValue_aroundBody1$advice(this, joinPoint, HtmlEncodingAspect.aspectOf(), (ProceedingJoinPoint)joinPoint);
    }

    public String getWikiSnippet() {
        return this.wikiSnippet;
    }

    @HtmlEncoding
    public static String getWikiSnippet(MetadataValue value) {
        MetadataValue metadataValue = value;
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_1, null, null, metadataValue);
        return (String)MetadataValue.getWikiSnippet_aroundBody3$advice(metadataValue, joinPoint, HtmlEncodingAspect.aspectOf(), (ProceedingJoinPoint)joinPoint);
    }

    public Number getValueAsNumber() {
        Object value = this.getValue();
        if (value instanceof Number) {
            return (Number)value;
        }
        if (value instanceof String) {
            return MathUtils.parseNumber((String)value);
        }
        return null;
    }

    public Date getValueAsDate() {
        Object value = this.getValue();
        if (value instanceof Date) {
            return (Date)value;
        }
        if (value instanceof String && value.toString().length() == 10) {
            try {
                String formattedDateAsString = value.toString().replaceAll("[-:;]", "/");
                return new SimpleDateFormat("dd/MM/yyyy").parse(formattedDateAsString);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return null;
    }

    public Boolean getValueAsBoolean() {
        Object value = this.getValue();
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof String) {
            return "true".equalsIgnoreCase((String)value) || "y".equalsIgnoreCase((String)value);
        }
        return null;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof MetadataValue)) {
            return false;
        }
        MetadataValue metadataValue = (MetadataValue)object;
        if (!Objects.equals(this.name, metadataValue.name)) {
            return false;
        }
        return Objects.equals(this.value, metadataValue.value);
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 29 * result + (this.value != null ? this.value.hashCode() : 0);
        return result;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    @Override
    public int compareTo(MetadataValue argument) {
        Date date = this.getValueAsDate();
        Date otherDate = argument.getValueAsDate();
        if (date != null && otherDate != null) {
            return date.compareTo(otherDate);
        }
        Number number = this.getValueAsNumber();
        Number otherNumber = argument.getValueAsNumber();
        if (number != null && otherNumber != null) {
            return (int)(number.doubleValue() - otherNumber.doubleValue());
        }
        return this.getWikiSnippet().compareTo(argument.getWikiSnippet());
    }

    public int compareValueAsIStringTo(MetadataValue argument) {
        String value1 = this.getValue().toString();
        String value2 = argument.getValue().toString();
        return value1.compareToIgnoreCase(value2);
    }

    public int compareValueAsStringTo(MetadataValue argument) {
        String value1 = this.getValue().toString();
        String value2 = argument.getValue().toString();
        return value1.compareTo(value2);
    }

    public int compareValueAsNumberTo(MetadataValue argument) {
        Number number = this.getValueAsNumber();
        Number otherNumber = argument.getValueAsNumber();
        if (number != null && otherNumber != null) {
            return (int)(number.doubleValue() - otherNumber.doubleValue());
        }
        return this.compareTo(argument);
    }

    static {
        MetadataValue.ajc$preClinit();
    }

    private static final /* synthetic */ Object getValue_aroundBody1$advice(MetadataValue ajc$this, JoinPoint thisJoinPoint, HtmlEncodingAspect ajc$aspectInstance, ProceedingJoinPoint pjp) {
        HtmlEncodingAspect.ajc$inlineAccessFieldGet$org_andya_confluence_plugins_metadata_aop_HtmlEncodingAspect$org_andya_confluence_plugins_metadata_aop_HtmlEncodingAspect$log().debug(pjp.toShortString());
        ProceedingJoinPoint proceedingJoinPoint = pjp;
        Object value = ajc$this.value;
        return HtmlEncodingAspect.ajc$inlineAccessMethod$org_andya_confluence_plugins_metadata_aop_HtmlEncodingAspect$org_andya_confluence_plugins_metadata_aop_HtmlEncodingAspect$escapeHtml(ajc$aspectInstance, value);
    }

    private static final /* synthetic */ String getWikiSnippet_aroundBody2(MetadataValue value, JoinPoint joinPoint) {
        return value != null ? value.getWikiSnippet() : "";
    }

    private static final /* synthetic */ Object getWikiSnippet_aroundBody3$advice(MetadataValue value, JoinPoint thisJoinPoint, HtmlEncodingAspect ajc$aspectInstance, ProceedingJoinPoint pjp) {
        HtmlEncodingAspect.ajc$inlineAccessFieldGet$org_andya_confluence_plugins_metadata_aop_HtmlEncodingAspect$org_andya_confluence_plugins_metadata_aop_HtmlEncodingAspect$log().debug(pjp.toShortString());
        ProceedingJoinPoint proceedingJoinPoint = pjp;
        String value2 = MetadataValue.getWikiSnippet_aroundBody2(value, proceedingJoinPoint);
        return HtmlEncodingAspect.ajc$inlineAccessMethod$org_andya_confluence_plugins_metadata_aop_HtmlEncodingAspect$org_andya_confluence_plugins_metadata_aop_HtmlEncodingAspect$escapeHtml(ajc$aspectInstance, value2);
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("MetadataValue.java", MetadataValue.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getValue", "org.andya.confluence.plugins.metadata.model.MetadataValue", "", "", "", "java.lang.Object"), 51);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "getWikiSnippet", "org.andya.confluence.plugins.metadata.model.MetadataValue", "org.andya.confluence.plugins.metadata.model.MetadataValue", "value", "", "java.lang.String"), 60);
    }
}

