/*
 * Decompiled with CFR 0.152.
 */
package org.andya.confluence.plugins.metadata;

import com.atlassian.bandana.BandanaContext;
import com.atlassian.bandana.BandanaManager;
import com.atlassian.confluence.content.render.xhtml.Renderer;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.event.events.content.page.PageEvent;
import com.atlassian.confluence.event.events.content.page.PageRemoveEvent;
import com.atlassian.confluence.event.events.content.page.PageRestoreEvent;
import com.atlassian.confluence.event.events.content.page.PageTrashedEvent;
import com.atlassian.confluence.event.events.content.page.PageUpdateEvent;
import com.atlassian.confluence.event.events.plugin.PluginEvent;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.setup.bandana.ConfluenceBandanaContext;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.event.events.PluginFrameworkStartedEvent;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import java.util.List;
import java.util.stream.Collectors;
import org.andya.confluence.plugins.metadata.MetadataUtils;
import org.andya.confluence.plugins.metadata.content.ComalaPropertiesSetManager;
import org.andya.confluence.utils.ContentService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.stereotype.Component;

@Component
public class PageUpdateListener
implements InitializingBean,
DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(PageUpdateListener.class);
    private static final String[] PLUGINS_USING_METADATAMODEL = new String[]{"com.comalatech.adhoccanvas", "com.comalatech.checklists", "com.comalatech.workflow"};
    public static final String UNSAFE_KEY = "org.andya.confluence.plugins.metadata.unsafe";
    private ComalaPropertiesSetManager contentPropertyManager;
    private final BandanaManager bandanaManager;
    private EventPublisher eventPublisher;
    private PluginAccessor pluginAccessor;
    private ContentService contentService;
    private Renderer viewRenderer;
    private boolean canClearMetadata = false;

    public PageUpdateListener(ComalaPropertiesSetManager contentPropertyManager, ContentService contentService, @ComponentImport EventPublisher eventPublisher, @ComponentImport PluginAccessor pluginAccessor, @ComponentImport Renderer viewRenderer, @ComponentImport BandanaManager bandanaManager) {
        this.contentPropertyManager = contentPropertyManager;
        this.eventPublisher = eventPublisher;
        this.pluginAccessor = pluginAccessor;
        this.viewRenderer = viewRenderer;
        this.bandanaManager = bandanaManager;
        this.contentService = contentService;
    }

    @EventListener
    public void handlePluginEvent(PluginEvent event) {
        this.canClearMetadata = this.isSafeToClearMetadata();
    }

    @EventListener
    public void handlePluginFrameworkStartedEvent(PluginFrameworkStartedEvent event) {
        this.canClearMetadata = this.isSafeToClearMetadata();
    }

    private boolean isSafeToClearMetadata() {
        Boolean unsafe = (Boolean)this.bandanaManager.getValue((BandanaContext)new ConfluenceBandanaContext(), UNSAFE_KEY);
        if (unsafe != null && unsafe.booleanValue()) {
            log.warn("marked unsafe already. If you want to remove metadata if metadata macros are removed from page's content, then remove bandana value 'org.andya.confluence.plugins.metadata.unsafe'");
            return false;
        }
        for (String pluginkey : PLUGINS_USING_METADATAMODEL) {
            if (this.pluginAccessor.getEnabledPlugin(pluginkey) == null) continue;
            log.warn("Not safe to clear metadata on page updates");
            this.bandanaManager.setValue((BandanaContext)new ConfluenceBandanaContext(), UNSAFE_KEY, (Object)true);
            return false;
        }
        log.warn("Metadata values will be remove if metadata macros are removed from page's content");
        return true;
    }

    @EventListener
    public void handleRemoveEvent(PageRemoveEvent event) {
        this.clearAndRerender((PageEvent)event, false);
    }

    @EventListener
    public void handleTrashedEvent(PageTrashedEvent event) {
        this.clearAndRerender((PageEvent)event, false);
    }

    @EventListener
    public void handleUpdatedEvent(PageUpdateEvent event) {
        Page page = event.getPage();
        AbstractPage oldPage = event.getOriginalPage();
        if (oldPage != null) {
            List<String> metadataOnPage = this.contentService.getMetadataMacroNamesFromPage((AbstractPage)page);
            List<String> metadataOnOldPage = this.contentService.getMetadataMacroNamesFromPage(oldPage);
            List metadataToRemove = metadataOnOldPage.stream().filter(metadata -> !metadataOnPage.contains(metadata)).collect(Collectors.toList());
            metadataToRemove.stream().forEach(arg_0 -> this.lambda$handleUpdatedEvent$1((AbstractPage)page, arg_0));
            if (!metadataToRemove.isEmpty()) {
                this.viewRenderer.render((ContentEntityObject)page);
            }
        }
    }

    @EventListener
    public void handleRestoreEvent(PageRestoreEvent event) {
        this.clearAndRerender((PageEvent)event, true);
    }

    private void clearAndRerender(PageEvent event, boolean reRender) {
        if (this.canClearMetadata) {
            MetadataUtils.clearAllMetadata(this.contentPropertyManager, event.getContent());
            if (reRender) {
                this.viewRenderer.render(event.getContent());
            }
        }
    }

    public void afterPropertiesSet() throws Exception {
        this.eventPublisher.register((Object)this);
    }

    public void destroy() throws Exception {
        this.eventPublisher.unregister((Object)this);
    }

    public void setContentPropertyManager(ComalaPropertiesSetManager contentPropertyManager) {
        this.contentPropertyManager = contentPropertyManager;
    }

    public void setEventPublisher(EventPublisher eventPublisher) {
        this.eventPublisher = eventPublisher;
    }

    public void setPluginAccessor(PluginAccessor pluginAccessor) {
        this.pluginAccessor = pluginAccessor;
    }

    public void setViewRenderer(Renderer viewRenderer) {
        this.viewRenderer = viewRenderer;
    }

    private /* synthetic */ void lambda$handleUpdatedEvent$1(AbstractPage page, String metadata) {
        MetadataUtils.removeMetadataValue(this.contentPropertyManager, (ContentEntityObject)page, metadata);
    }
}

