/*
 * Decompiled with CFR 0.152.
 */
package org.andya.confluence.plugins.metadata;

import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.v2.RenderMode;
import com.atlassian.renderer.v2.macro.MacroException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.andya.confluence.plugins.metadata.AbstractMetadataMacro;
import org.andya.confluence.plugins.metadata.MetadataUsingMacro;
import org.andya.confluence.plugins.metadata.MetadataUtils;
import org.andya.confluence.plugins.metadata.model.MetadataContent;
import org.andya.confluence.plugins.metadata.model.MetadataValue;
import org.andya.confluence.utils.MacroUtils;

public class MetadataMatchesMacro
extends MetadataUsingMacro {
    public MetadataMatchesMacro() {
        super("metadata-matches");
    }

    public boolean isInline() {
        return true;
    }

    @Override
    public boolean hasBody() {
        return true;
    }

    @Override
    public RenderMode getBodyRenderMode() {
        return null;
    }

    @Override
    public String doExecute(Map parameters, String body, RenderContext renderContext) throws MacroException {
        try {
            String valueName = MacroUtils.getStringParameter(parameters, "0", true);
            String functionName = MacroUtils.getStringParameter(parameters, "function", "sum");
            String calculationValueName = MacroUtils.getStringParameter(parameters, "value-name", null);
            List<MetadataContent> contents = this.getMatchingPages(parameters, renderContext, false, this.getSystemMaxResultsForPages());
            ArrayList<Number> values = new ArrayList<Number>();
            int total = 0;
            for (MetadataContent content : contents) {
                MetadataValue value = content.getMetadataValue(valueName);
                String wikiSnippet = value != null ? value.getWikiSnippet() : "";
                if (!body.equals(wikiSnippet)) continue;
                if (calculationValueName != null) {
                    MetadataValue calculationValue = content.getMetadataValue(calculationValueName);
                    Number number = calculationValue.getValueAsNumber();
                    if (number == null) continue;
                    values.add(number);
                    continue;
                }
                ++total;
            }
            if (values.isEmpty()) {
                return AbstractMetadataMacro.reportLimitHitFlag.get() != false ? MetadataUtils.getPageLimitMessage("Page", this.getI18nResolver()) + "\n" + total : Integer.toString(total);
            }
            return this.renderCalculation(functionName, values);
        }
        catch (Exception e) {
            return this.showUnrenderedExceptionString(parameters, e);
        }
    }
}

