/*
 * Decompiled with CFR 0.152.
 */
package org.andya.confluence.utils.page;

import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.v2.macro.MacroException;
import java.util.EnumMap;
import java.util.Map;
import org.andya.confluence.utils.page.resolver.IdPageResolverImpl;
import org.andya.confluence.utils.page.resolver.ParentPageResolverImpl;
import org.andya.confluence.utils.page.resolver.SelfPageResolverImpl;
import org.andya.confluence.utils.page.resolver.SpacePageResolverImpl;
import org.andya.confluence.utils.page.resolver.TitlePageResolverImpl;
import org.andya.confluence.utils.page.resolver.contract.PageResolver;
import org.andya.confluence.utils.page.resolver.model.ResolverType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FindPage {
    private static final Logger log = LoggerFactory.getLogger(FindPage.class);
    private final Map<ResolverType, PageResolver> resolvers = new EnumMap<ResolverType, PageResolver>(ResolverType.class);
    private final PageResolver defaultResolver;

    public FindPage(PageManager pageManager) {
        this.resolvers.put(ResolverType.BY_ID, new IdPageResolverImpl(pageManager));
        this.resolvers.put(ResolverType.BY_SPACE, new SpacePageResolverImpl(pageManager));
        this.resolvers.put(ResolverType.BY_TITLE, new TitlePageResolverImpl(pageManager));
        this.resolvers.put(ResolverType.BY_SELF, new SelfPageResolverImpl());
        this.resolvers.put(ResolverType.BY_PARENT, new ParentPageResolverImpl());
        this.defaultResolver = (value, renderContext, spaceKey) -> {
            throw new MacroException("Page value '" + value + "' is not valid");
        };
    }

    public Page find(String pageName, RenderContext renderContext, String spaceKey) throws MacroException {
        return this.find(pageName, renderContext, spaceKey, true);
    }

    public Page find(String pageName, RenderContext renderContext, String spaceKey, boolean required) throws MacroException {
        try {
            ResolverType resolverType = ResolverType.getByExpression(pageName);
            return this.resolvers.getOrDefault((Object)resolverType, this.defaultResolver).resolve(pageName, renderContext, spaceKey);
        }
        catch (MacroException macroException) {
            log.debug("MacroException while trying to get the page.", (Throwable)macroException);
            if (required) {
                throw macroException;
            }
            return null;
        }
    }
}

