/*
 * Decompiled with CFR 0.152.
 */
package org.andya.confluence.plugins.metadata.supplier;

import com.atlassian.confluence.core.ConfluenceEntityObject;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.search.v2.AbstractSearchResult;
import com.servicerocket.confluence.randombits.supplier.core.SupplierContext;
import com.servicerocket.confluence.randombits.supplier.core.annotate.AnnotatedSupplier;
import com.servicerocket.confluence.randombits.supplier.core.annotate.KeyContext;
import com.servicerocket.confluence.randombits.supplier.core.annotate.KeyParam;
import com.servicerocket.confluence.randombits.supplier.core.annotate.SupplierKey;
import com.servicerocket.confluence.randombits.supplier.core.annotate.SupplierPrefix;
import com.servicerocket.confluence.randombits.supplier.core.annotate.SupportedTypes;
import org.andya.confluence.plugins.metadata.MetadataUtils;
import org.andya.confluence.plugins.metadata.model.MetadataValue;
import org.andya.confluence.utils.ContentService;
import org.apache.commons.lang.StringUtils;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

@SupplierPrefix(value={"metadata"})
@SupportedTypes(value={ContentEntityObject.class, AbstractSearchResult.class})
public class MetadataSupplier
extends AnnotatedSupplier {
    private final ContentService contentService;
    private final PageManager pageManager;

    public MetadataSupplier(ContentService contentService, PageManager pageManager) {
        this.contentService = contentService;
        this.pageManager = pageManager;
    }

    @SupplierKey(value={"{key}"})
    public Object getContent(@KeyContext SupplierContext context, @KeyParam(value="key") String key) {
        String stringValue;
        ContentEntityObject page;
        Object value = context.getValue();
        if (value instanceof ContentEntityObject) {
            page = (ContentEntityObject)value;
        } else if (value instanceof AbstractSearchResult) {
            AbstractSearchResult currentContent = (AbstractSearchResult)value;
            page = this.pageManager.getPage(currentContent.getSpaceKey(), currentContent.getDisplayTitle());
        } else {
            return context.getValue();
        }
        if (StringUtils.isBlank((String)key)) {
            return MetadataUtils.getAllMetadata(this.contentService, page).entrySet();
        }
        MetadataValue metadataValue = MetadataUtils.getMetadataValue(this.contentService, (ConfluenceEntityObject)page, key, null);
        String string = stringValue = metadataValue != null ? metadataValue.getWikiSnippet() : null;
        if (StringUtils.isNotBlank((String)stringValue)) {
            DateTimeFormatter dateParser = ISODateTimeFormat.dateParser();
            try {
                return dateParser.parseDateTime(stringValue).toDate();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return stringValue;
    }
}

