/*
 * Decompiled with CFR 0.152.
 */
package org.andya.confluence.utils.parse;

import com.atlassian.renderer.v2.macro.MacroException;
import java.util.LinkedList;
import java.util.StringTokenizer;
import org.andya.confluence.utils.parse.AndExpression;
import org.andya.confluence.utils.parse.Expression;
import org.andya.confluence.utils.parse.LabelExpression;
import org.andya.confluence.utils.parse.OrExpression;

public class ExpressionParser {
    private static final int TT_OPEN = 0;
    private static final int TT_CLOSE = 1;
    private static final int TT_LABEL = 2;
    private static final int TT_OR = 3;
    private static final int TT_AND = 4;

    public Expression parse(String expression) throws MacroException {
        LinkedList<Token> tokenStream = this.parseTokens(expression, new LinkedList<Token>());
        Expression exp = this.parseExpression(tokenStream);
        if (!tokenStream.isEmpty()) {
            throw new MacroException("Encountered extra tokens - '" + tokenStream + "'");
        }
        return exp;
    }

    Expression parseExpression(LinkedList<Token> tokenStream) throws MacroException {
        Expression first;
        if (tokenStream.isEmpty()) {
            throw new MacroException("Expected '(' or label, was no expression!");
        }
        Token t = tokenStream.removeFirst();
        if (t.type == 0) {
            first = this.parseExpression(tokenStream);
            if (tokenStream.isEmpty()) {
                throw new MacroException("Expected ')', was end of stream");
            }
            t = tokenStream.removeFirst();
            if (t.type != 1) {
                throw new MacroException("Expected ')', was '" + t.token + "'");
            }
        } else if (t.type == 2) {
            first = new LabelExpression(t.token);
        } else {
            throw new MacroException("Expected '(' or label, was '" + t.token + "'");
        }
        if (tokenStream.isEmpty()) {
            return first;
        }
        t = tokenStream.getFirst();
        if (t.type == 3 || t.type == 4) {
            tokenStream.removeFirst();
            Expression right = this.parseExpression(tokenStream);
            if (t.type == 3) {
                return new OrExpression(first, right);
            }
            return new AndExpression(first, right);
        }
        return first;
    }

    LinkedList<Token> parseTokens(String expression, LinkedList<Token> tokenList) {
        Token t;
        if ((expression = expression.trim()).length() == 0) {
            return tokenList;
        }
        char ch = expression.charAt(0);
        if (ch == '(') {
            t = new Token(0, "(");
        } else if (ch == ')') {
            t = new Token(1, ")");
        } else if (ch == ',') {
            t = new Token(3, ",");
        } else if (ch == '+') {
            t = new Token(4, "+");
        } else {
            String label = this.consume(expression);
            t = new Token(2, label);
        }
        tokenList.add(t);
        return this.parseTokens(expression.substring(t.token.length()), tokenList);
    }

    private String consume(String expression) {
        return new StringTokenizer(expression, ",+()").nextToken();
    }

    private static final class Token {
        private final int type;
        private final String token;

        public Token(int type, String token) {
            this.type = type;
            this.token = token;
        }

        public String toString() {
            return this.token;
        }
    }
}

