/*
 * Decompiled with CFR 0.152.
 */
package org.andya.confluence.utils.page;

import com.atlassian.confluence.api.model.Expansion;
import com.atlassian.confluence.api.model.content.Content;
import com.atlassian.confluence.api.model.pagination.PageRequest;
import com.atlassian.confluence.api.model.pagination.PageResponse;
import com.atlassian.confluence.api.model.pagination.SimplePageRequest;
import com.atlassian.confluence.api.service.search.CQLSearchService;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.renderer.v2.macro.MacroException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.andya.confluence.plugins.metadata.AbstractMetadataMacro;
import org.andya.confluence.utils.ContentUtils;
import org.andya.confluence.utils.page.PageSearchContext;
import org.andya.confluence.utils.page.PageSource;
import org.apache.commons.lang3.StringUtils;

public class PagesPageSource
implements PageSource {
    private static final String TYPE_PAGE = "  AND type = page";
    private static final String ANCESTOR = "ancestor";
    private static final String ID = "id";
    private final PageSource child;

    public PagesPageSource(PageSource child) {
        this.child = child;
    }

    @Override
    public List<Page> getPages(PageSearchContext context) throws MacroException {
        LinkedList<Page> entities = new LinkedList<Page>();
        String pagesCode = context.getStringParameter("pages", true);
        CQLSearchService cqlSearchService = context.getCqlSearchService();
        PageManager pageManager = context.getPageManager();
        List<Page> rootPages = this.child.getPages(context);
        for (Page page : rootPages) {
            if (!"@children".equalsIgnoreCase(pagesCode)) {
                entities.addAll(this.getEntitiesForNoChildrenCase(context, pagesCode, cqlSearchService, pageManager, page));
                continue;
            }
            StringBuilder cqlQuery = this.getCqlQueryByFilterEqual(ANCESTOR, page.getIdAsString());
            List<Page> descendants = this.searchWithCql(cqlQuery, cqlSearchService, pageManager, context);
            for (Page descendant : descendants) {
                if (!page.getIdAsString().equals(descendant.getParent().getIdAsString())) continue;
                entities.add(descendant);
            }
        }
        return entities;
    }

    private List<Page> getEntitiesForNoChildrenCase(PageSearchContext context, String pagesCode, CQLSearchService cqlSearchService, PageManager pageManager, Page page) throws MacroException {
        String pageId = page.getIdAsString();
        if ("@ancestors".equalsIgnoreCase(pagesCode)) {
            return page.getAncestors();
        }
        if ("@descendents".equalsIgnoreCase(pagesCode) || "@descendants".equalsIgnoreCase(pagesCode)) {
            StringBuilder cqlQuery = this.getCqlQueryByFilterEqual(ANCESTOR, pageId);
            return this.searchWithCql(cqlQuery, cqlSearchService, pageManager, context);
        }
        if ("@identity".equalsIgnoreCase(pagesCode)) {
            StringBuilder cqlQuery = this.getCqlQueryByFilterEqual(ID, pageId);
            return this.searchWithCql(cqlQuery, cqlSearchService, pageManager, context);
        }
        throw new MacroException("Unknown pages code '" + pagesCode + "'");
    }

    private StringBuilder getCqlQueryByFilterEqual(String filterClause, String pageId) {
        return new StringBuilder(filterClause + " = " + ContentUtils.quoteString(pageId) + TYPE_PAGE);
    }

    private List<Page> searchWithCql(StringBuilder cqlQuery, CQLSearchService cqlSearchService, PageManager pageManager, PageSearchContext context) {
        PageResponse pageResponse;
        ArrayList<Page> pages = new ArrayList<Page>();
        if (StringUtils.isNotBlank((CharSequence)context.getSpaceKey())) {
            String quotedKey = ContentUtils.quoteString(context.getSpaceKey());
            cqlQuery.append(" AND space.key = ").append(quotedKey);
        }
        cqlQuery.append(" ORDER BY title ASC");
        do {
            pageResponse = cqlSearchService.searchContent(cqlQuery.toString(), (PageRequest)new SimplePageRequest(pages.size(), 500), new Expansion[0]);
            ArrayList<Long> contentIds = new ArrayList<Long>();
            for (Content content : pageResponse.getResults()) {
                contentIds.add(content.getId().asLong());
            }
            pages.addAll(pageManager.getPages(contentIds));
        } while (pageResponse.hasMore() && pages.size() < context.getMaxResults());
        if (pages.size() >= context.getMaxResults()) {
            AbstractMetadataMacro.reportLimitHitFlag.set(true);
        }
        return pages;
    }
}

