/*
 * Decompiled with CFR 0.152.
 */
package org.andya.confluence.plugins.metadata.space;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.macro.MacroExecutionException;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.v2.RenderMode;
import com.atlassian.renderer.v2.macro.MacroException;
import java.util.Map;
import org.andya.confluence.plugins.metadata.MetadataUtils;
import org.andya.confluence.plugins.metadata.space.AbstractSpaceMetadataMacro;
import org.andya.confluence.utils.MacroUtils;

public class SpaceMetadataListMacro
extends AbstractSpaceMetadataMacro {
    public SpaceMetadataListMacro() {
        super("space-metadata-list");
    }

    public boolean hasBody() {
        return true;
    }

    public RenderMode getBodyRenderMode() {
        return null;
    }

    @Override
    public String doExecute(Map parameters, String body, RenderContext renderContext) throws MacroException {
        try {
            boolean hidden = MacroUtils.getBooleanParameter(parameters, "hidden");
            boolean clear = MacroUtils.getBooleanParameter(parameters, "clear");
            boolean horizontal = MacroUtils.getBooleanParameter(parameters, "orientation", "horizontal", false);
            Space space = this.getSpace(renderContext);
            if (clear && this.isReadOnlyModeDisabled()) {
                MetadataUtils.clearAllMetadata(this.getContentPropertyManager(), (ContentEntityObject)space.getDescription());
            }
            return this.addMetadataList(space, body, hidden, horizontal, renderContext.getOutputType());
        }
        catch (Exception e) {
            return this.showUnrenderedExceptionString(parameters, e);
        }
    }

    public String execute(Map parameters, String body, ConversionContext conversionContext) throws MacroExecutionException {
        String rawBody = super.execute((Map<String, String>)parameters, body, conversionContext);
        return this.renderString((RenderContext)conversionContext.getPageContext(), conversionContext.getEntity(), rawBody);
    }
}

