/*
 * Decompiled with CFR 0.152.
 */
package org.andya.confluence.plugins.metadata.model;

import com.atlassian.renderer.v2.macro.MacroException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public class MetadataList {
    private final List<String> names = new ArrayList<String>();
    private final List<String> values = new ArrayList<String>();

    public List<String> getNames() {
        return this.names;
    }

    public List<String> getValues() {
        return this.values;
    }

    public void addNameAndValue(String name, String value) {
        this.names.add(name);
        this.values.add(value);
    }

    public void addRow(String row) throws MacroException {
        if ((row = row.trim()).length() == 0) {
            return;
        }
        int startIndex = 0;
        int endIndex = row.length();
        if (row.charAt(0) == '|') {
            startIndex = endIndex > 1 && row.charAt(1) == '|' ? 2 : 1;
        }
        if (startIndex == endIndex) {
            throw new MacroException("Metadata list entry missing name: \"" + row + "\"");
        }
        while (endIndex > startIndex && (row.charAt(endIndex - 1) == '|' || row.charAt(endIndex - 1) == '\\' || row.charAt(endIndex - 1) == ' ')) {
            if (endIndex >= 2 && row.charAt(endIndex - 1) == '\\' && row.charAt(endIndex - 2) == '\\') {
                --endIndex;
            } else if (row.charAt(endIndex - 1) == '\\') break;
            --endIndex;
        }
        int nameEndIndex = row.indexOf(124, startIndex);
        String name = row.substring(startIndex, nameEndIndex);
        if ((name = name.replace("\\\\", "").trim()).length() == 0) {
            throw new MacroException("Metadata list entry missing name: \"" + row + "\"");
        }
        startIndex = nameEndIndex + 1;
        String value = startIndex >= endIndex ? "" : row.substring(startIndex, endIndex).trim();
        this.addNameAndValue(name, value);
    }

    public static MetadataList parseMetadataList(String body) throws MacroException {
        MetadataList list = new MetadataList();
        StringTokenizer tokenizer = new StringTokenizer(body, "\n");
        if (tokenizer.countTokens() > 0) {
            StringBuilder currentRow = new StringBuilder(tokenizer.nextToken());
            while (tokenizer.hasMoreTokens()) {
                String s = tokenizer.nextToken();
                if (s.charAt(0) == '|') {
                    list.addRow(currentRow.toString());
                    currentRow = new StringBuilder(s);
                    continue;
                }
                currentRow.append("\n").append(s);
            }
            list.addRow(currentRow.toString());
        }
        return list;
    }
}

