/*
 * Decompiled with CFR 0.152.
 */
package org.andya.confluence.plugins.metadata.model;

import org.andya.confluence.utils.Duration;
import org.andya.confluence.utils.MathUtils;

public class ColumnStatistics {
    private boolean isDuration;
    private boolean isInteger = true;
    private double total = 0.0;

    public void recordValue(String value) {
        Number number = MathUtils.parseNumber(value);
        if (number != null) {
            this.total += number.doubleValue();
            if (number instanceof Duration) {
                this.isDuration = true;
            } else if (number instanceof Double) {
                this.isInteger = false;
            }
        }
    }

    public boolean isInteger() {
        return this.isInteger;
    }

    public boolean isDuration() {
        return this.isDuration;
    }

    public Number getTotal() {
        double total = this.total;
        if (this.isDuration()) {
            return new Duration((long)total);
        }
        if (this.isInteger()) {
            return (int)total;
        }
        return total;
    }
}

