/*
 * Decompiled with CFR 0.152.
 */
package org.andya.confluence.plugins.metadata;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.AttachmentManager;
import com.atlassian.confluence.pages.Page;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.v2.RenderMode;
import com.atlassian.renderer.v2.macro.MacroException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.andya.confluence.plugins.metadata.AbstractMetadataMacro;
import org.andya.confluence.plugins.metadata.model.MetadataContent;
import org.andya.confluence.plugins.metadata.renderers.MetadataRenderer;
import org.andya.confluence.utils.MacroUtils;

public class AttachmentsReportMacro
extends AbstractMetadataMacro {
    private AttachmentManager attachmentManager;

    public AttachmentsReportMacro() {
        super("attachments-report");
    }

    public boolean hasBody() {
        return false;
    }

    public RenderMode getBodyRenderMode() {
        return RenderMode.NO_RENDER;
    }

    @Override
    public String doExecute(Map parameters, String body, RenderContext renderContext) throws MacroException {
        try {
            String commaDelimitedColumns = MacroUtils.getStringParameter(parameters, "0", true);
            int maxResults = this.getMaxResultsForPages(parameters);
            List<MetadataContent> attachments = this.getMatchingAttachments(parameters, renderContext, true);
            String[] columns = commaDelimitedColumns.split(",");
            String commaDelimitedTotals = MacroUtils.getStringParameter(parameters, "totals", "");
            MetadataRenderer renderer = this.getMetadataRenderer(parameters);
            return renderer.render(renderContext, attachments, maxResults, columns, commaDelimitedTotals, "User", this.getI18nResolver());
        }
        catch (Exception e) {
            return MacroUtils.showRenderedExceptionString(parameters, "Unable to render macro", e.getMessage());
        }
    }

    public List<MetadataContent> getMatchingAttachments(Map parameters, RenderContext renderContext, boolean ordered) throws MacroException {
        AbstractPage page = this.getPage(renderContext);
        if (page instanceof Page) {
            return this.getSortedContents(parameters, this.attachmentManager.getAllVersionsOfAttachments((ContentEntityObject)page), ordered ? "Attachment" : null);
        }
        return Collections.emptyList();
    }

    public void setAttachmentManager(AttachmentManager attachmentManager) {
        this.attachmentManager = attachmentManager;
    }
}

