/*
 * Decompiled with CFR 0.152.
 */
package org.andya.confluence.plugins.metadata.space;

import com.atlassian.confluence.spaces.Space;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.v2.RenderMode;
import com.atlassian.renderer.v2.components.HtmlEscaper;
import com.atlassian.renderer.v2.macro.MacroException;
import java.util.Map;
import org.andya.confluence.plugins.metadata.AbstractMetadataMacro;
import org.andya.confluence.plugins.metadata.MetadataUtils;
import org.andya.confluence.plugins.metadata.space.AbstractSpaceMetadataMacro;
import org.andya.confluence.plugins.metadata.space.SpaceDetails;
import org.andya.confluence.plugins.metadata.space.SpaceHierarchyService;
import org.andya.confluence.utils.MacroUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.springframework.beans.factory.InitializingBean;

public class SpaceHierarchyMacro
extends AbstractSpaceMetadataMacro
implements InitializingBean {
    private SpaceHierarchyService hierarchyService;

    public SpaceHierarchyMacro() {
        super("space-hierarchy");
    }

    public boolean isInline() {
        return true;
    }

    public boolean hasBody() {
        return false;
    }

    public RenderMode getBodyRenderMode() {
        return RenderMode.NO_RENDER;
    }

    @Override
    public String doExecute(Map parameters, String body, RenderContext renderContext) throws MacroException {
        try {
            Space currentSpace = this.getSpace(renderContext);
            if (parameters.containsKey("space")) {
                currentSpace = this.getSpaceManager().getSpace((String)parameters.get("space"));
            }
            if (currentSpace == null) {
                return MacroUtils.showRenderedExceptionString(parameters, "Wrong parameters", "Cannot find space");
            }
            SpaceDetails hierarchyDetails = this.hierarchyService.buildChildrenHierarchy(currentSpace.getKey(), this.findSpacesForCurrentUser(this.getSystemMaxResultsForSpaces()));
            StringBuffer html = new StringBuffer();
            if (BooleanUtils.isTrue((Boolean)AbstractMetadataMacro.reportLimitHitFlag.get())) {
                html.append(MetadataUtils.getPageLimitMessage("Space", this.getI18nResolver()));
            }
            html.append("<table border='0'>\n");
            this.appendSpaceInfo(html, renderContext, hierarchyDetails, 0);
            html.append("</table>\n");
            return html.toString();
        }
        catch (Exception e) {
            return MacroUtils.showRenderedExceptionString(parameters, "Unable to render macro", e);
        }
    }

    private void appendSpaceInfo(StringBuffer html, RenderContext renderContext, SpaceDetails hierarchy, int depth) {
        if (hierarchy != null) {
            if (hierarchy.getSpaceKey() != null) {
                html.append("<tr><td>");
                for (int i = 0; i < depth * 4; ++i) {
                    html.append("&nbsp;");
                }
                html.append("<img src='").append(renderContext.getImagePath()).append("/icons/browse_space.gif' width='16' height='16' />");
                html.append("&nbsp;<a href='");
                html.append(renderContext.getSiteRoot()).append(hierarchy.getUrlPath());
                html.append("'>");
                html.append(HtmlEscaper.escapeAll((String)hierarchy.getName(), (boolean)true));
                html.append("</a>");
                html.append("</td></tr>\n");
            }
            for (SpaceDetails child : hierarchy.getChildren()) {
                this.appendSpaceInfo(html, renderContext, child, depth + 1);
            }
        }
    }

    public void afterPropertiesSet() throws Exception {
        this.hierarchyService = new SpaceHierarchyService(this.getContentService(), this.getSpaceManager());
    }
}

