/*
 * Decompiled with CFR 0.152.
 */
package org.andya.confluence.plugins.metadata.model;

import org.andya.confluence.plugins.metadata.model.ColumnStatistics;
import org.andya.confluence.utils.MathUtils;

public class ReportStatistics {
    private final boolean[] shouldTotal;
    private final ColumnStatistics[] columnStatistics;

    public ReportStatistics(int columnCount) {
        this.shouldTotal = new boolean[columnCount];
        this.columnStatistics = new ColumnStatistics[columnCount];
    }

    public int getColumnCount() {
        return this.shouldTotal.length;
    }

    public boolean shouldTotal(int column) {
        return this.shouldTotal[column];
    }

    public void setShouldTotal(int column, boolean shouldTotal) {
        this.shouldTotal[column] = shouldTotal;
    }

    public String getTotalString(int column) {
        if (!this.shouldTotal(column)) {
            return "";
        }
        ColumnStatistics statistics = this.getColumnStatistics(column);
        Number total = statistics.getTotal();
        return MathUtils.toString(total);
    }

    public ColumnStatistics getColumnStatistics(int column) {
        ColumnStatistics statistics = this.columnStatistics[column];
        if (statistics == null) {
            this.columnStatistics[column] = statistics = new ColumnStatistics();
        }
        return statistics;
    }

    public void recordValue(int column, String value) {
        if (!this.shouldTotal(column) || value == null) {
            return;
        }
        ColumnStatistics statistics = this.getColumnStatistics(column);
        statistics.recordValue(value);
    }
}

