/*
 * Decompiled with CFR 0.152.
 */
package org.andya.confluence.plugins.metadata;

import com.atlassian.confluence.api.service.accessmode.AccessModeService;
import com.atlassian.confluence.api.service.search.CQLSearchService;
import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.content.render.xhtml.LinkRenderer;
import com.atlassian.confluence.core.ConfluenceEntityObject;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.FormatSettingsManager;
import com.atlassian.confluence.labels.LabelManager;
import com.atlassian.confluence.labels.SpaceLabelManager;
import com.atlassian.confluence.languages.LocaleManager;
import com.atlassian.confluence.macro.Macro;
import com.atlassian.confluence.macro.MacroExecutionException;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.BlogPost;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.renderer.PageContext;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.security.SpacePermissionManager;
import com.atlassian.confluence.setup.settings.DarkFeaturesManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.v2.RenderMode;
import com.atlassian.renderer.v2.SubRenderer;
import com.atlassian.renderer.v2.macro.BaseMacro;
import com.atlassian.renderer.v2.macro.MacroException;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.user.UserManager;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.andya.confluence.plugins.metadata.AbstractMetadataMacro$AjcClosure1;
import org.andya.confluence.plugins.metadata.MetadataUtils;
import org.andya.confluence.plugins.metadata.aop.HtmlEncodingAspect;
import org.andya.confluence.plugins.metadata.aop.HtmlEncodingParameter;
import org.andya.confluence.plugins.metadata.content.ComalaPropertiesSetManager;
import org.andya.confluence.plugins.metadata.license.MetadataLicenseManager;
import org.andya.confluence.plugins.metadata.model.MetadataContent;
import org.andya.confluence.plugins.metadata.model.MetadataList;
import org.andya.confluence.plugins.metadata.model.MetadataSortOrder;
import org.andya.confluence.plugins.metadata.model.MetadataValue;
import org.andya.confluence.plugins.metadata.renderers.MetadataListRenderer;
import org.andya.confluence.plugins.metadata.renderers.MetadataRenderer;
import org.andya.confluence.plugins.metadata.renderers.MetadataTableRenderer;
import org.andya.confluence.utils.ContentService;
import org.andya.confluence.utils.MacroConstants;
import org.andya.confluence.utils.MacroUtils;
import org.andya.confluence.utils.page.FindPage;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;

public abstract class AbstractMetadataMacro
extends BaseMacro
implements MacroConstants,
Macro {
    private final String macroName;
    @ComponentImport
    private SubRenderer subRenderer;
    private SpaceManager spaceManager;
    @ComponentImport
    private SpaceLabelManager spaceLabelManager;
    @ComponentImport
    private PageManager pageManager;
    private UserManager userManager;
    private ContentService contentService;
    private ComalaPropertiesSetManager contentPropertyManager;
    @ComponentImport
    private PermissionManager permissionManager;
    @ComponentImport
    private LabelManager labelManager;
    private FormatSettingsManager formatSettingsManager;
    @ComponentImport
    private LinkRenderer linkRenderer;
    private MetadataLicenseManager licenseManager;
    @ComponentImport
    private SpacePermissionManager spacePermissionManager;
    @ComponentImport
    private AccessModeService accessModeService;
    @ComponentImport
    private CQLSearchService cqlSearchService;
    private I18nResolver i18nResolver;
    private LocaleManager localeManager;
    @ComponentImport
    private DarkFeaturesManager darkFeaturesManager;
    public static ThreadLocal<Boolean> reportLimitHitFlag;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    protected AbstractMetadataMacro(String macroName) {
        this.macroName = macroName;
    }

    public String getMacroName() {
        return this.macroName;
    }

    public Macro.BodyType getBodyType() {
        if (this.hasBody()) {
            return Macro.BodyType.PLAIN_TEXT;
        }
        return Macro.BodyType.NONE;
    }

    public Macro.OutputType getOutputType() {
        return Macro.OutputType.BLOCK;
    }

    public String execute(Map<String, String> parameters, String body, ConversionContext conversionContext) throws MacroExecutionException {
        reportLimitHitFlag.set(false);
        try {
            return this.execute(parameters, this.cleanBody(body), (RenderContext)conversionContext.getPageContext());
        }
        catch (MacroException e) {
            throw new MacroExecutionException(e.getMessage(), (Throwable)e);
        }
    }

    public String execute(Map parameters, String body, RenderContext renderContext) throws MacroException {
        if (this.isAppLicensed()) {
            return this.doExecute(parameters, this.cleanBody(body), renderContext);
        }
        return this.licenseManager.getLicenseMessageHtml() + "\n" + this.doExecute(parameters, this.cleanBody(body), renderContext);
    }

    protected abstract String doExecute(Map var1, String var2, RenderContext var3) throws MacroException;

    protected String cleanBody(String body) {
        return body.replace('\u00a0', ' ').trim();
    }

    public void setLinkRenderer(LinkRenderer linkRenderer) {
        this.linkRenderer = linkRenderer;
    }

    public SpaceManager getSpaceManager() {
        return this.spaceManager;
    }

    public void setSpaceManager(SpaceManager spaceManager) {
        this.spaceManager = spaceManager;
    }

    public SpaceLabelManager getSpaceLabelManager() {
        return this.spaceLabelManager;
    }

    public void setSpaceLabelManager(SpaceLabelManager spaceLabelManager) {
        this.spaceLabelManager = spaceLabelManager;
    }

    public PageManager getPageManager() {
        return this.pageManager;
    }

    public void setPageManager(PageManager pageManager) {
        this.pageManager = pageManager;
    }

    public UserManager getUserManager() {
        return this.userManager;
    }

    public void setUserManager(UserManager userManager) {
        this.userManager = userManager;
    }

    public FormatSettingsManager getFormatSettingsManager() {
        return this.formatSettingsManager;
    }

    public void setFormatSettingsManager(FormatSettingsManager formatSettingsManager) {
        this.formatSettingsManager = formatSettingsManager;
    }

    public PermissionManager getPermissionManager() {
        return this.permissionManager;
    }

    public void setPermissionManager(PermissionManager permissionManager) {
        this.permissionManager = permissionManager;
    }

    public SpacePermissionManager getSpacePermissionManager() {
        return this.spacePermissionManager;
    }

    public void setSpacePermissionManager(SpacePermissionManager spacePermissionManager) {
        this.spacePermissionManager = spacePermissionManager;
    }

    public ComalaPropertiesSetManager getContentPropertyManager() {
        return this.contentPropertyManager;
    }

    public void setContentPropertyManager(ComalaPropertiesSetManager contentPropertyManager) {
        this.contentPropertyManager = contentPropertyManager;
    }

    protected SubRenderer getSubRenderer() {
        return this.subRenderer;
    }

    public void setSubRenderer(SubRenderer subRenderer) {
        this.subRenderer = subRenderer;
    }

    public LabelManager getLabelManager() {
        return this.labelManager;
    }

    public void setLabelManager(LabelManager manager) {
        this.labelManager = manager;
    }

    public MetadataLicenseManager getLicenseManager() {
        return this.licenseManager;
    }

    public void setLicenseManager(MetadataLicenseManager licenseManager) {
        this.licenseManager = licenseManager;
    }

    public CQLSearchService getCqlSearchService() {
        return this.cqlSearchService;
    }

    public void setCqlSearchService(CQLSearchService cqlSearchService) {
        this.cqlSearchService = cqlSearchService;
    }

    public I18nResolver getI18nResolver() {
        return this.i18nResolver;
    }

    public void setI18nResolver(I18nResolver i18nResolver) {
        this.i18nResolver = i18nResolver;
    }

    public boolean isAppLicensed() {
        return this.licenseManager.isLicensed() || this.licenseManager.isDevelopmentMode();
    }

    public void setAccessModeService(AccessModeService accessModeService) {
        this.accessModeService = accessModeService;
    }

    public boolean isReadOnlyModeDisabled() {
        return !this.accessModeService.isReadOnlyAccessModeEnabled();
    }

    public LocaleManager getLocaleManager() {
        return this.localeManager;
    }

    public void setLocaleManager(LocaleManager localeManager) {
        this.localeManager = localeManager;
    }

    public DarkFeaturesManager getDarkFeaturesManager() {
        return this.darkFeaturesManager;
    }

    public void setDarkFeaturesManager(DarkFeaturesManager darkFeaturesManager) {
        this.darkFeaturesManager = darkFeaturesManager;
    }

    public ConfluenceUser getUser() {
        return AuthenticatedUserThreadLocal.get();
    }

    protected ContentEntityObject getEntity(RenderContext renderContext) {
        if (renderContext instanceof PageContext) {
            PageContext pageContext = (PageContext)renderContext;
            return pageContext.getEntity();
        }
        return null;
    }

    protected AbstractPage getPage(RenderContext renderContext) {
        ContentEntityObject ceo = this.getEntity(renderContext);
        if (ceo instanceof Page) {
            return (Page)ceo;
        }
        if (ceo instanceof BlogPost) {
            return (BlogPost)ceo;
        }
        return null;
    }

    protected Page getPage(RenderContext renderContext, String pageName) throws MacroException {
        return this.getPage(renderContext, pageName, true);
    }

    protected Page getPage(RenderContext renderContext, String pageName, boolean required) throws MacroException {
        if ("@self".equalsIgnoreCase(pageName) || "@parent".equalsIgnoreCase(pageName)) {
            ContentEntityObject ceo = this.getEntity(renderContext);
            if (ceo instanceof Page) {
                Page page = (Page)ceo;
                if ("@parent".equalsIgnoreCase(pageName)) {
                    Page parentPage = page.getParent();
                    if (parentPage == null && required) {
                        throw new MacroException("No parent for page: " + page);
                    }
                    return parentPage;
                }
                return page;
            }
            if (required) {
                String blogTitle = ceo.getTitle();
                throw new MacroException("Cannot use " + pageName + " on a non-page: " + blogTitle);
            }
            return null;
        }
        return new FindPage(this.getPageManager()).find(pageName, renderContext, null, required);
    }

    public MetadataValue getMetadataValue(ContentEntityObject ceo, String valueName) {
        return this.getMetadataValue(ceo, valueName, null);
    }

    public MetadataValue getMetadataValue(ContentEntityObject ceo, String valueName, String defaultValue) {
        return MetadataUtils.getMetadataValue(this.getContentService(), (ConfluenceEntityObject)ceo, valueName, defaultValue);
    }

    public ContentService getContentService() {
        return this.contentService;
    }

    public void setContentService(ContentService contentService) {
        this.contentService = contentService;
    }

    public void setMetadataValue(ContentEntityObject ceo, String valueName, String unrenderedValue) {
        MetadataUtils.setMetadataValue(this.getContentPropertyManager(), ceo, valueName, unrenderedValue);
    }

    public void setMetadataValue(RenderContext renderContext, String valueName, String unrenderedValue) {
        MetadataUtils.setMetadataValue(this.getContentPropertyManager(), renderContext, valueName, unrenderedValue);
    }

    protected String renderValue(RenderContext renderContext, MetadataValue value) {
        String wikiSnippet = value != null ? value.getWikiSnippet() : "";
        return this.renderString(renderContext, wikiSnippet);
    }

    protected String renderValue(RenderContext renderContext, ContentEntityObject ceo, MetadataValue value) {
        if (renderContext instanceof PageContext) {
            PageContext pageContext = new PageContext(ceo, (PageContext)renderContext);
            return this.renderValue((RenderContext)pageContext, value);
        }
        return this.renderValue(renderContext, value);
    }

    @HtmlEncodingParameter
    protected String renderString(RenderContext renderContext, String string) {
        RenderContext renderContext2 = renderContext;
        String string2 = string;
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_0, this, this, renderContext2, string2);
        Object[] objectArray = new Object[]{this, renderContext2, string2, joinPoint};
        AbstractMetadataMacro$AjcClosure1 abstractMetadataMacro$AjcClosure1 = new AbstractMetadataMacro$AjcClosure1(objectArray);
        return (String)HtmlEncodingAspect.aspectOf().encodeMetadataParameter(abstractMetadataMacro$AjcClosure1.linkClosureAndJoinPoint(69648));
    }

    protected String renderString(RenderContext renderContext, ContentEntityObject ceo, String string) {
        if (renderContext instanceof PageContext) {
            PageContext pageContext = new PageContext(ceo, (PageContext)renderContext);
            return this.renderString((RenderContext)pageContext, string);
        }
        return this.renderString(renderContext, string);
    }

    protected String showRenderedExceptionString(Map parameters, Throwable e) {
        return MacroUtils.showRenderedExceptionString(parameters, "Unable to show \"" + this.getMacroName() + "\"", e);
    }

    protected String showRenderedExceptionString(Map parameters, String message) {
        return MacroUtils.showRenderedExceptionString(parameters, "Unable to show \"" + this.getMacroName() + "\"", message);
    }

    protected String showUnrenderedExceptionString(Map parameters, Throwable e) {
        return MacroUtils.showUnrenderedExceptionString(parameters, "Unable to show \"" + this.getMacroName() + "\"", e);
    }

    protected String addMetadataList(Space space, String body, boolean hidden, boolean horizontal, String outputType) throws MacroException {
        return this.addMetadataList((ContentEntityObject)space.getDescription(), body, hidden, horizontal, outputType);
    }

    protected String addMetadataList(ContentEntityObject ceo, String body, boolean hidden, boolean horizontal, String outputType) throws MacroException {
        String value;
        String valueName2;
        int i;
        MetadataList list = MetadataList.parseMetadataList(body);
        StringBuilder buffer = new StringBuilder();
        List<String> names = list.getNames();
        List<String> values = list.getValues();
        if (outputType == null || !outputType.equals("preview")) {
            for (i = 0; i < names.size(); ++i) {
                valueName2 = names.get(i);
                value = values.get(i);
                if (ceo == null || !this.isReadOnlyModeDisabled()) continue;
                this.setMetadataValue(ceo, valueName2, value);
            }
        }
        if (hidden) {
            return "";
        }
        if (horizontal) {
            for (String valueName2 : names) {
                buffer.append("||");
                buffer.append(valueName2);
            }
            buffer.append("||\n");
            for (int i2 = 0; i2 < names.size(); ++i2) {
                String value2 = values.get(i2);
                buffer.append("|");
                buffer.append(value2.length() == 0 ? " " : value2);
            }
            buffer.append("|\n");
        } else {
            for (i = 0; i < names.size(); ++i) {
                valueName2 = names.get(i);
                value = values.get(i);
                buffer.append("||");
                buffer.append(valueName2);
                buffer.append("|");
                buffer.append(value.length() == 0 ? " " : value);
                buffer.append("|\n");
            }
        }
        return buffer.toString();
    }

    public MetadataRenderer getMetadataRenderer(Map parameters) throws MacroException {
        String style = MacroUtils.getStringParameter(parameters, "style", "table");
        if ("list".equals(style) || "ol".equals(style) || "ul".equals(style)) {
            return new MetadataListRenderer(this.getSubRenderer(), style, this.linkRenderer);
        }
        if ("table".equals(style)) {
            return new MetadataTableRenderer(this.getSubRenderer(), this.linkRenderer);
        }
        throw new MacroException("Unrecognized style " + style + " for metadata renderer");
    }

    public List<MetadataContent> getSortedContents(Map parameters, List<ConfluenceEntityObject> entities, String defaultSortColumn) throws MacroException {
        List<MetadataContent> contents = MetadataUtils.getMetadataContent(this.getContentService(), entities);
        if (defaultSortColumn != null) {
            String commaDelimitedSort = MacroUtils.getStringParameter(parameters, "sort", "");
            MetadataSortOrder[] sortOrders = MetadataSortOrder.getMetadataSortOrders(commaDelimitedSort);
            Comparator<MetadataContent> comparator = MetadataSortOrder.getComparator(sortOrders, defaultSortColumn);
            contents.sort(comparator);
        }
        return contents;
    }

    protected int getMaxResultsForSpaces(Map parameters) throws MacroException {
        int maxResults = MacroUtils.getIntParameter(parameters, "maxResults", 500);
        return Math.min(maxResults, this.getSystemMaxResultsForSpaces());
    }

    protected int getSystemMaxResultsForSpaces() {
        if (this.darkFeaturesManager.getDarkFeatures().isFeatureEnabled("com.comalatech.metadata.space.limit.disabled")) {
            return Integer.MAX_VALUE;
        }
        return MetadataUtils.getSystemMaxSpaceResults();
    }

    protected int getMaxResultsForPages(Map parameters) throws MacroException {
        int maxResults = MacroUtils.getIntParameter(parameters, "maxResults", 500);
        return Math.min(maxResults, this.getSystemMaxResultsForPages());
    }

    protected int getSystemMaxResultsForPages() {
        if (this.darkFeaturesManager.getDarkFeatures().isFeatureEnabled("com.comalatech.metadata.page.limit.disabled")) {
            return Integer.MAX_VALUE;
        }
        return MetadataUtils.getSystemMaxPageResults();
    }

    protected int getMaxResultsForUsers(Map parameters) throws MacroException {
        int maxResults = MacroUtils.getIntParameter(parameters, "maxResults", 500);
        return Math.min(maxResults, this.getSystemMaxResultsForUsers());
    }

    protected int getSystemMaxResultsForUsers() {
        if (this.darkFeaturesManager.getDarkFeatures().isFeatureEnabled("com.comalatech.metadata.user.limit.disabled")) {
            return Integer.MAX_VALUE;
        }
        return MetadataUtils.getSystemMaxUserResults();
    }

    static {
        AbstractMetadataMacro.ajc$preClinit();
        reportLimitHitFlag = new ThreadLocal();
    }

    static final /* synthetic */ String renderString_aroundBody0(AbstractMetadataMacro ajc$this, RenderContext renderContext, String string, JoinPoint joinPoint) {
        return ajc$this.getSubRenderer().render(string != null ? string : "", renderContext, renderContext.getRenderMode().and(RenderMode.suppress((long)256L)));
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("AbstractMetadataMacro.java", AbstractMetadataMacro.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "renderString", "org.andya.confluence.plugins.metadata.AbstractMetadataMacro", "com.atlassian.renderer.RenderContext:java.lang.String", "renderContext:string", "", "java.lang.String"), 429);
    }
}

