/*
 * Decompiled with CFR 0.152.
 */
package nl.avisi.confluence.plugins.gitplugin.upgrades;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.activeobjects.external.ActiveObjectsUpgradeTask;
import com.atlassian.activeobjects.external.ModelVersion;
import com.atlassian.sal.api.transaction.TransactionCallback;
import nl.avisi.confluence.plugins.gitplugin.core.GitAttachment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GitAttachmentBranchUpgradeTask
implements ActiveObjectsUpgradeTask {
    private static final String DEFAULT_BRANCH = "master";
    private static final Logger LOG = LoggerFactory.getLogger(GitAttachmentBranchUpgradeTask.class);

    public ModelVersion getModelVersion() {
        return ModelVersion.valueOf((String)"100500300");
    }

    public void upgrade(ModelVersion currentVersion, final ActiveObjects ao) {
        LOG.info("Starting Git Attachment 'Branch' migration");
        ao.executeInTransaction((TransactionCallback)new TransactionCallback<Object>(){

            public Object doInTransaction() {
                GitAttachment[] gitAttachments;
                ao.migrate(new Class[]{GitAttachment.class});
                for (GitAttachment gitAttachment : gitAttachments = (GitAttachment[])ao.find(GitAttachment.class)) {
                    gitAttachment.setBranch(GitAttachmentBranchUpgradeTask.DEFAULT_BRANCH);
                    gitAttachment.save();
                    LOG.info("Updated Git Attachment: " + gitAttachment.getID());
                }
                return null;
            }
        });
    }
}

