/*
 * Decompiled with CFR 0.152.
 */
package nl.avisi.confluence.plugins.gitplugin.configuration.service;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import nl.avisi.confluence.plugins.gitplugin.attachment.rest.dto.CommitInformation;
import nl.avisi.confluence.plugins.gitplugin.attachment.rest.dto.GitInformation;
import nl.avisi.confluence.plugins.gitplugin.attachment.service.GitAttachmentService;
import nl.avisi.confluence.plugins.gitplugin.configuration.dao.RepositoryDao;
import nl.avisi.confluence.plugins.gitplugin.configuration.service.RepositoryService;
import nl.avisi.confluence.plugins.gitplugin.configuration.service.SecurityService;
import nl.avisi.confluence.plugins.gitplugin.core.GitAttachment;
import nl.avisi.confluence.plugins.gitplugin.core.Repository;
import nl.avisi.confluence.plugins.gitplugin.core.Server;
import nl.avisi.confluence.plugins.gitplugin.git.exception.ListRepositoryBranchesException;
import nl.avisi.confluence.plugins.gitplugin.git.exception.RepositoryInitializationException;
import nl.avisi.confluence.plugins.gitplugin.git.exception.RepositoryUpdateException;
import nl.avisi.confluence.plugins.gitplugin.git.manager.VCSRepositoryManager;
import org.apache.commons.io.IOUtils;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.diff.DiffEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
public class RepositoryServiceImpl
implements RepositoryService {
    private static final Logger LOG = LoggerFactory.getLogger(RepositoryServiceImpl.class);
    private final RepositoryDao repositoryDao;
    private final VCSRepositoryManager repositoryManager;
    private final SecurityService securityService;
    private final GitAttachmentService gitAttachmentService;

    @Inject
    public RepositoryServiceImpl(@Nonnull RepositoryDao repositoryDao, @Nonnull VCSRepositoryManager repositoryManager, @Nonnull SecurityService securityService, @Nonnull GitAttachmentService gitAttachmentService) {
        this.repositoryDao = (RepositoryDao)Preconditions.checkNotNull((Object)repositoryDao);
        this.repositoryManager = (VCSRepositoryManager)Preconditions.checkNotNull((Object)repositoryManager);
        this.securityService = (SecurityService)Preconditions.checkNotNull((Object)securityService);
        this.gitAttachmentService = (GitAttachmentService)Preconditions.checkNotNull((Object)gitAttachmentService);
    }

    public Repository create(Server server, String name, String path) throws RepositoryInitializationException {
        Preconditions.checkNotNull((Object)server);
        Preconditions.checkNotNull((Object)name);
        Preconditions.checkNotNull((Object)path);
        Repository repository = this.repositoryDao.create(server, name, path);
        this.repositoryManager.create(repository);
        try {
            repository.setLastIndexedTimestamp(this.repositoryManager.getLastCommitTimeStamp(repository));
            this.repositoryDao.update(repository);
        }
        catch (Exception e) {
            LOG.error("Failed setting lastIndexedTimestamp on repository", (Throwable)e);
            throw new RepositoryInitializationException(name, path, (Throwable)e);
        }
        return repository;
    }

    public void update(Repository repository, String name, String path) throws RepositoryInitializationException {
        Preconditions.checkNotNull((Object)repository);
        String oldPath = repository.getPath();
        repository.setName(name);
        repository.setPath(path);
        this.repositoryDao.update(repository);
        if (!oldPath.equals(path)) {
            this.repositoryManager.reset(repository);
            repository.setLastSynchronized(new Date());
            this.repositoryDao.update(repository);
        }
    }

    public Optional<Repository> get(int id) {
        return this.repositoryDao.get(id);
    }

    public Collection<Repository> getRepositories(boolean checkPermissions) {
        List<Repository> repositories = this.repositoryDao.findAll();
        if (checkPermissions) {
            LOG.debug("Filtering repositories on 'canUse' permission");
            return Collections2.filter(repositories, (Predicate)new Predicate<Repository>(){

                public boolean apply(@Nullable Repository repository) {
                    return RepositoryServiceImpl.this.securityService.canUse(repository);
                }
            });
        }
        return repositories;
    }

    public Collection<Repository> findByName(String name) {
        return this.repositoryDao.findByName(name);
    }

    public void delete(int id) {
        Optional<Repository> optional = this.repositoryDao.get(id);
        Preconditions.checkState((boolean)optional.isPresent());
        Repository repository = optional.get();
        this.securityService.clearGroups(repository);
        repository.getServer();
        this.repositoryDao.delete(id);
        this.repositoryManager.delete(repository);
    }

    public void archive(int id) {
        Optional<Repository> optional = this.repositoryDao.get(id);
        Preconditions.checkState((boolean)optional.isPresent());
        Repository repository = optional.get();
        repository.getServer();
        repository.setArchived(true);
        repository.save();
        this.repositoryManager.delete(repository);
    }

    public void unarchive(int id) {
        Optional<Repository> optional = this.repositoryDao.get(id);
        Preconditions.checkState((boolean)optional.isPresent());
        Repository repository = optional.get();
        repository.setArchived(false);
        repository.save();
    }

    public void updateRepository(Repository repository) throws RepositoryUpdateException {
        Map changesPerAttachment = this.repositoryManager.update(repository);
        LOG.debug("Found {} changes since last update", (Object)changesPerAttachment.size());
        repository.setLastSynchronized(new Date());
        this.repositoryDao.update(repository);
        this.processChangedFiles(repository, changesPerAttachment);
    }

    private void processChangedFiles(Repository repository, Map<GitAttachment, List<DiffEntry>> changesPerAttachment) {
        for (GitAttachment attachment : changesPerAttachment.keySet()) {
            List<DiffEntry> changes = changesPerAttachment.get(attachment);
            for (DiffEntry diffEntry : changes) {
                DiffEntry.ChangeType changeType;
                LOG.debug("The file '" + diffEntry.getOldPath() + "' changed, changetype: " + String.valueOf(diffEntry.getChangeType()));
                if (!diffEntry.getOldPath().equals(attachment.getFilePath()) || (changeType = diffEntry.getChangeType()) == DiffEntry.ChangeType.ADD || changeType == DiffEntry.ChangeType.COPY || changeType == DiffEntry.ChangeType.RENAME) continue;
                if (changeType == DiffEntry.ChangeType.MODIFY) {
                    try {
                        String commitId = this.repositoryManager.getCommitId(repository, attachment.getBranch());
                        this.gitAttachmentService.updateAttachment(attachment, commitId);
                    }
                    catch (IOException e) {
                        LOG.warn("There was an unexpected error updating attachment {}", (Object)attachment.getFilePath());
                    }
                    continue;
                }
                if (changeType == DiffEntry.ChangeType.DELETE) {
                    this.gitAttachmentService.removeAttachment(attachment);
                    continue;
                }
                Object[] arguments = new String[]{diffEntry.getChangeType().toString(), diffEntry.getOldPath(), attachment.getBranch()};
                LOG.warn("Unknown change type {} for file {} on branch {}", arguments);
            }
        }
    }

    public String getFileContents(Repository repository, String branch, String commitId, String path) throws IOException {
        try (InputStream inputStream = this.getInputStream(repository, branch, commitId, path);){
            String string = IOUtils.toString((InputStream)inputStream, (Charset)Charset.defaultCharset());
            return string;
        }
    }

    public InputStream getInputStream(Repository repository, String branch, String commitId, String path) throws IOException {
        return this.repositoryManager.getFileDetails(repository, branch, commitId, path).getFileContents();
    }

    public Collection<String> getBranches(Repository repository) throws ListRepositoryBranchesException {
        return this.repositoryManager.getBranches(repository);
    }

    public Collection<String> getCommits(Repository repository, String branch, String term, int maxCount, int start) throws IOException, GitAPIException {
        String commit;
        Collection commits = this.repositoryManager.getCommits(repository, branch, maxCount, start);
        if (!term.isEmpty() && (commit = this.repositoryManager.getSearchedCommit(repository, branch, term)) != null) {
            commits.add(commit);
        }
        commits.add(Integer.toString(this.repositoryManager.getCommitsCount(repository, branch)));
        return commits;
    }

    public Collection<String> getTags(Repository repository) throws ListRepositoryBranchesException {
        return this.repositoryManager.getTags(repository);
    }

    public Collection<String> listFilesInDirectory(Repository repository, String branch, String commitId, String path) throws IOException {
        return this.orderDirectory((List)this.repositoryManager.listFilesInDirectory(repository, branch, commitId, path));
    }

    public List<Repository> findByPath(String repositoryPath) {
        List<Repository> repository = this.repositoryDao.findByPath(repositoryPath);
        if (repository.size() == 0) {
            LOG.warn("No repository matching repository was found for search parameter: {}", (Object)repositoryPath);
        } else if (repository.size() > 1) {
            LOG.warn("Multiple repositories where found, expected 1 found: {} search parameter: {}", (Object)repository.size(), (Object)repositoryPath);
        }
        return repository;
    }

    public GitInformation getGitInformation(Repository repository, String uriSource) throws IOException, ListRepositoryBranchesException, GitAPIException {
        GitInformation gitInformation = new GitInformation();
        this.repositoryManager.deriveBranchAndCommitIdFromUrl(gitInformation, repository, uriSource);
        this.repositoryManager.derivePathFromUrl(gitInformation, repository, uriSource);
        if (gitInformation.getBranch() == null || gitInformation.getPath() == null | gitInformation.getCommitId() == null || gitInformation.getBranch().equals("") || gitInformation.getPath().equals("")) {
            LOG.error("Error retrieving GitInformation. Repository name: {} input parameter: uriSource= {} results: Branch= {} Path= {} CommitId= {} ", (Object[])new String[]{repository.getName(), uriSource, gitInformation.getBranch(), gitInformation.getPath(), gitInformation.getCommitId()});
        }
        return gitInformation;
    }

    public CommitInformation getCommitInformation(Repository repository, String branch, String path, String commitId) {
        CommitInformation commitInformation = new CommitInformation();
        try {
            return this.repositoryManager.getCommitInformation(repository, branch, path, commitId, commitInformation);
        }
        catch (Exception e) {
            LOG.debug("Error retrieving information: " + String.valueOf(e));
            return commitInformation;
        }
    }

    public List<String> getRepositoryDirectory(Repository repository, String branch, String commit, String path) throws GitAPIException, IOException {
        return this.orderDirectory(this.repositoryManager.getRepositoryDirectory(repository, branch, commit, path));
    }

    private List<String> orderDirectory(List<String> unsortedDirectory) {
        Collections.sort(unsortedDirectory, String.CASE_INSENSITIVE_ORDER);
        ArrayList<String> sortedDirectory = new ArrayList<String>();
        sortedDirectory.addAll(unsortedDirectory.stream().filter(n -> n.startsWith(".")).sorted().collect(Collectors.toList()));
        sortedDirectory.addAll(unsortedDirectory.stream().filter(n -> n.endsWith("/")).sorted().collect(Collectors.toList()));
        sortedDirectory.addAll(unsortedDirectory.stream().filter(n -> !n.contains(".")).filter(n -> !n.contains("/")).collect(Collectors.toList()));
        sortedDirectory.addAll(unsortedDirectory.stream().filter(n -> n.contains(".")).filter(n -> !n.startsWith(".")).collect(Collectors.toList()));
        return sortedDirectory;
    }
}

