/*
 * Decompiled with CFR 0.152.
 */
package nl.avisi.confluence.plugins.gitplugin.configuration.rest.mappers;

import com.atlassian.sal.api.message.I18nResolver;
import com.google.common.base.Preconditions;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.ext.ExceptionMapper;
import jakarta.ws.rs.ext.Provider;
import javax.annotation.Nonnull;
import nl.avisi.confluence.plugins.gitplugin.exceptions.RestError;
import nl.avisi.confluence.plugins.gitplugin.git.exception.RepositoryInitializationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
public class RepositoryInitializationExceptionMapper
implements ExceptionMapper<RepositoryInitializationException> {
    private final I18nResolver i18nResolver;
    private static final Logger LOG = LoggerFactory.getLogger(RepositoryInitializationExceptionMapper.class);

    public RepositoryInitializationExceptionMapper(@Nonnull I18nResolver i18nResolver) {
        this.i18nResolver = (I18nResolver)Preconditions.checkNotNull((Object)i18nResolver);
    }

    public Response toResponse(RepositoryInitializationException e) {
        LOG.warn("Unable to clone repository '{}' ({})", (Object)e.getRepositoryName(), (Object)e.getRepositoryUri());
        return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)new RestError(this.i18nResolver.getText(e.getMessage()))).build();
    }
}

