/*
 * Decompiled with CFR 0.152.
 */
package nl.avisi.confluence.plugins.gitplugin.configuration.rest.mappers;

import com.atlassian.sal.api.message.I18nResolver;
import com.google.common.base.Preconditions;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.ext.ExceptionMapper;
import jakarta.ws.rs.ext.Provider;
import javax.annotation.Nonnull;
import nl.avisi.confluence.plugins.gitplugin.exceptions.AbstractNotFoundException;
import nl.avisi.confluence.plugins.gitplugin.exceptions.RestError;

@Provider
public class NotFoundExceptionMapper
implements ExceptionMapper<AbstractNotFoundException> {
    @Nonnull
    private final I18nResolver i18nResolver;

    public NotFoundExceptionMapper(@Nonnull I18nResolver i18nResolver) {
        this.i18nResolver = (I18nResolver)Preconditions.checkNotNull((Object)i18nResolver);
    }

    public Response toResponse(AbstractNotFoundException e) {
        String message = this.i18nResolver.getText(e.getI18nMessage());
        RestError restError = new RestError(message);
        return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)restError).build();
    }
}

