/*
 * Decompiled with CFR 0.152.
 */
package nl.avisi.confluence.plugins.gitplugin.configuration.rest;

import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.net.URI;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Named;
import nl.avisi.confluence.plugins.gitplugin.configuration.rest.AddServer;
import nl.avisi.confluence.plugins.gitplugin.configuration.rest.LicenseCheckBaseResource;
import nl.avisi.confluence.plugins.gitplugin.configuration.rest.RestRepository;
import nl.avisi.confluence.plugins.gitplugin.configuration.rest.RestServer;
import nl.avisi.confluence.plugins.gitplugin.configuration.rest.Utils;
import nl.avisi.confluence.plugins.gitplugin.configuration.service.ServerService;
import nl.avisi.confluence.plugins.gitplugin.core.Server;
import nl.avisi.confluence.plugins.gitplugin.license.LicenseChecker;
import nl.avisi.confluence.plugins.gitplugin.validation.ServerValidator;

@Named
@Path(value="/servers")
@Produces(value={"application/json"})
public class ServerResource
extends LicenseCheckBaseResource {
    private final ServerService serverService;
    private final ServerValidator serverValidator;
    private final Utils utils;

    @Inject
    public ServerResource(ServerService serverService, LicenseChecker licenseChecker, ServerValidator serverValidator, Utils utils) {
        super(licenseChecker);
        this.serverService = (ServerService)Preconditions.checkNotNull((Object)serverService);
        this.serverValidator = (ServerValidator)Preconditions.checkNotNull((Object)serverValidator);
        this.utils = utils;
    }

    @GET
    public Response all() {
        this.checkLicense();
        return Response.ok(RestServer.collection(this.serverService.all())).build();
    }

    @POST
    @Consumes(value={"application/json"})
    @WebSudoRequired
    public Response save(AddServer addServer, @Context UriInfo uriInfo) {
        this.checkLicense();
        this.utils.checkAdminPermission();
        this.serverValidator.validateForSave(addServer);
        Server server = this.serverService.createServer(addServer.getName(), addServer.getServerInfo(), addServer.getServerAuthentication());
        return Response.created((URI)uriInfo.getAbsolutePathBuilder().path(String.valueOf(server.getID())).build(new Object[0])).entity((Object)new RestServer(server)).build();
    }

    @PUT
    @Path(value="{serverId}")
    @Consumes(value={"application/json"})
    @WebSudoRequired
    public Response update(@PathParam(value="serverId") String serverId, AddServer addServer) {
        this.checkLicense();
        this.utils.checkAdminPermission();
        Server server = this.utils.serverIdToServer(serverId);
        this.serverValidator.validateForUpdate(addServer);
        if (addServer.hasMaskedPassword()) {
            addServer.getServerAuthentication().setPassword(server.getPassword());
        }
        this.serverService.update(server, addServer.getName(), addServer.getServerInfo(), addServer.getServerAuthentication());
        return Response.ok().build();
    }

    @GET
    @Path(value="{serverId}")
    public Response get(@PathParam(value="serverId") String serverId) {
        this.checkLicense();
        Server server = this.utils.serverIdToServer(serverId);
        return Response.ok((Object)new RestServer(server)).build();
    }

    @DELETE
    @Path(value="{serverId}")
    @WebSudoRequired
    public Response delete(@PathParam(value="serverId") String serverId) {
        this.checkLicense();
        this.utils.checkAdminPermission();
        Server server = this.utils.serverIdToServer(serverId);
        this.serverService.delete(server);
        return Response.ok().build();
    }

    @GET
    @Path(value="{serverId}/repositories")
    public Response getRepositoriesForServer(@PathParam(value="serverId") String serverId) {
        this.checkLicense();
        Server server = this.utils.serverIdToServer(serverId);
        return Response.ok(RestRepository.collection(Lists.newArrayList((Object[])server.getRepositories()))).build();
    }

    @GET
    @Path(value="by-host")
    public Response serverByUrlHost(@QueryParam(value="urlHost") String urlHost) {
        this.checkLicense();
        Optional<Server> optServer = this.serverService.getByHost(urlHost);
        if (optServer.isPresent()) {
            Server server = optServer.get();
            return Response.ok((Object)server.getID()).build();
        }
        return Response.status((int)404).build();
    }
}

