/*
 * Decompiled with CFR 0.152.
 */
package nl.avisi.confluence.plugins.gitplugin.configuration.rest;

import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.atlassian.user.EntityException;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import javax.inject.Named;
import nl.avisi.confluence.plugins.gitplugin.configuration.rest.LicenseCheckBaseResource;
import nl.avisi.confluence.plugins.gitplugin.configuration.rest.Utils;
import nl.avisi.confluence.plugins.gitplugin.configuration.service.SecurityService;
import nl.avisi.confluence.plugins.gitplugin.core.Group;
import nl.avisi.confluence.plugins.gitplugin.core.Repository;
import nl.avisi.confluence.plugins.gitplugin.license.LicenseChecker;

@Named
@Path(value="security/groups")
@Produces(value={"application/json"})
public class SecurityGroupResource
extends LicenseCheckBaseResource {
    private final SecurityService securityService;
    private final Utils utils;

    @Inject
    public SecurityGroupResource(@Nonnull SecurityService securityService, @Nonnull LicenseChecker licenseChecker, Utils utils) {
        super(licenseChecker);
        this.securityService = (SecurityService)Preconditions.checkNotNull((Object)securityService);
        this.utils = utils;
    }

    @GET
    public Response all() throws EntityException {
        return Response.ok(this.securityService.getAllGroups()).build();
    }

    @PUT
    @Path(value="{repositoryId}")
    @Consumes(value={"application/json"})
    @WebSudoRequired
    public Response setGroups(@PathParam(value="repositoryId") String repositoryId, List<String> groups) {
        this.checkLicense();
        Repository repository = this.utils.repositoryIdToRepository(repositoryId);
        this.securityService.clearGroups(repository);
        this.securityService.addGroups(repository, groups);
        return Response.ok().build();
    }

    @GET
    @Path(value="{repositoryId}")
    @Consumes(value={"application/json"})
    public Response getGroups(@PathParam(value="repositoryId") String repositoryId) {
        this.checkLicense();
        Repository repository = this.utils.repositoryIdToRepository(repositoryId);
        Collection groups = Collections2.transform((Collection)Lists.newArrayList((Object[])repository.getGroups()), (Function)new Function<Group, String>(){

            public String apply(Group input) {
                return input.getName();
            }
        });
        return Response.ok((Object)groups).build();
    }
}

