/*
 * Decompiled with CFR 0.152.
 */
package nl.avisi.confluence.plugins.gitplugin.configuration.rest;

import com.google.common.base.Preconditions;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.util.List;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import javax.inject.Named;
import nl.avisi.confluence.plugins.gitplugin.configuration.rest.RestRepositoryHealthCheckFailed;
import nl.avisi.confluence.plugins.gitplugin.configuration.service.RepositoryHealthCheckService;

@Named
@Path(value="/health-check")
@Produces(value={"application/json"})
public class RepositoryHealthCheckResource {
    private final RepositoryHealthCheckService repositoryHealthCheckService;

    @Inject
    public RepositoryHealthCheckResource(@Nonnull RepositoryHealthCheckService repositoryHealthCheckService) {
        this.repositoryHealthCheckService = (RepositoryHealthCheckService)Preconditions.checkNotNull((Object)repositoryHealthCheckService);
    }

    @GET
    @Path(value="/check")
    public Response check() {
        return Response.ok(this.repositoryHealthCheckService.check()).build();
    }

    @GET
    @Path(value="/fix")
    public Response fix() {
        List<RestRepositoryHealthCheckFailed> errors = this.repositoryHealthCheckService.fix();
        if (errors.isEmpty()) {
            return Response.ok().build();
        }
        return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity(errors).build();
    }
}

