/*
 * Decompiled with CFR 0.152.
 */
package nl.avisi.confluence.plugins.gitplugin.configuration.dao;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Named;
import net.java.ao.DBParam;
import net.java.ao.Query;
import net.java.ao.RawEntity;
import nl.avisi.confluence.plugins.gitplugin.configuration.dao.RepositoryDao;
import nl.avisi.confluence.plugins.gitplugin.core.Repository;
import nl.avisi.confluence.plugins.gitplugin.core.Server;

@Named
public class ActiveObjectsRepositoryDao
implements RepositoryDao {
    private final ActiveObjects activeObjects;

    @Inject
    public ActiveObjectsRepositoryDao(@ComponentImport ActiveObjects activeObjects) {
        this.activeObjects = (ActiveObjects)Preconditions.checkNotNull((Object)activeObjects);
    }

    @Override
    public Repository create(Server server, String name, String path) {
        Preconditions.checkNotNull((Object)server);
        Preconditions.checkNotNull((Object)name);
        Preconditions.checkNotNull((Object)path);
        Repository repository = (Repository)this.activeObjects.create(Repository.class, new DBParam[]{new DBParam("SERVER_ID", (Object)server), new DBParam("NAME", (Object)name), new DBParam("PATH", (Object)path), new DBParam("LAST_SYNCHRONIZED", (Object)new Date()), new DBParam("ARCHIVED", (Object)false)});
        repository.save();
        return repository;
    }

    @Override
    public void update(Repository repository) {
        repository.save();
    }

    @Override
    public Optional<Repository> get(int id) {
        Repository repository = (Repository)this.activeObjects.get(Repository.class, (Object)id);
        return Optional.ofNullable(repository);
    }

    @Override
    public List<Repository> findAll() {
        Object[] repositories = (Repository[])this.activeObjects.find(Repository.class);
        return Lists.newArrayList((Object[])repositories);
    }

    @Override
    public List<Repository> findByName(String name) {
        Object[] repositories = (Repository[])this.activeObjects.find(Repository.class, Query.select().where("NAME = ?", new Object[]{name}));
        return Lists.newArrayList((Object[])repositories);
    }

    @Override
    public void delete(int id) {
        Optional<Repository> optionalRepository = this.get(id);
        Preconditions.checkArgument((boolean)optionalRepository.isPresent());
        this.activeObjects.delete(new RawEntity[]{(RawEntity)optionalRepository.get()});
    }

    @Override
    public List<Repository> findByPath(String repositoryPath) {
        Object[] repositories = (Repository[])this.activeObjects.find(Repository.class, Query.select().where("PATH = ?", new Object[]{repositoryPath}));
        return Lists.newArrayList((Object[])repositories);
    }
}

