(function($) {

  filter = function(options, filterOn) {
    result = [];
    for (var i = 0; i < options.length; i++) {
      if (options[i].text.toLowerCase().includes(filterOn.toLowerCase())) {
        console.log(options[i].text)
        result.push(options[i])
      }
    }
    return result;
  }

  $.fn.gitPluginSyntaxSelect = function(options) {
    var cache = [];
    var $element = this;

    var settings = $.extend({}, options);

    $element.auiSelect2({
      placeholder : AJS.I18n.getText("gitplugin.attachment.dialog.language.select"),
      minimumInputLength : 0,
      width : "100%",
      closeOnSelect : true,
      adaptContainerCssClass : function(clazz) {
        // filter out macro-param-input for macro browser issues
        if (clazz === "macro-param-input") {
          return null
        }
        return clazz;
      },

      query : function(query) {
        if (cache.length === 0) {
          AJS.$.ajax({
            url : AJS.contextPath() + "/plugins/newcode/getlanguages.action",
            dataType : 'json',
            cache : false,
            error : function(xhr) {
                cache = [
                  {id: "AS3", text: "ActionScript"},
                  {id: "AppleScript", text: "AppleScript"},
                  {id: "Bash", text: "Bash"},
                  {id: "CSharp", text: "C#"},
                  {id: "Cpp", text: "C++"},
                  {id: "CSS", text: "CSS"},
                  {id: "ColdFusion", text: "ColdFusion"},
                  {id: "cucumber_nl", text: "Cucumber NL"},
                  {id: "Delphi", text: "Delphi"},
                  {id: "Diff", text: "Diff"},
                  {id: "Erland", text: "Erlang"},
                  {id: "Groovy", text: "Groovy"},
                  {id: "Xml", text: "HTML and XML"},
                  {id: "Java", text: "Java"},
                  {id: "JavaFX", text: "Java FX"},
                  {id: "JScript", text: "JavaScript"},
                  {id: "Php", text: "PHP"},
                  {id: "Perl", text: "Perl"},
                  {id: "Plain", text: "Plain Text"},
                  {id: "PowerShell", text: "PowerShell"},
                  {id: "Python", text: "Python"},
                  {id: "Ruby", text: "Ruby"},
                  {id: "Sql", text: "SQL"},
                  {id: "Sass", text: "Sass"},
                  {id: "Scala", text: "Scala"},
                  {id: "Vb", text: "Visual Basic"},
                  {id: "Yaml", text: "YAML"}
                ]
            },
            success : function(repositories) {
              for (var i = 0; i < repositories.length; i++) {
                cache.push({id : repositories[i].name, text : repositories[i].friendlyName});
              }
            }
          });
        }
        query.callback({results : filter(cache, query.term)});
      }
    });

    if (!_.isEmpty(settings.initialValue)) {
      $element.auiSelect2("data", {id: settings.initialValue, text: settings.initialValue});
    }

    return this;
  }

}(AJS.$));
