/*
 * Decompiled with CFR 0.152.
 */
package nl.avisi.confluence.plugins.gitplugin.configuration.rest;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Collections2;
import java.util.Collection;
import javax.annotation.Nullable;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import nl.avisi.confluence.plugins.gitplugin.core.Server;
import nl.avisi.confluence.plugins.gitplugin.core.ServerAuthentication;
import nl.avisi.confluence.plugins.gitplugin.core.ServerInfo;

@XmlRootElement
public class RestServer {
    public static final String PASSWORD_MASK = "#####";
    @XmlElement
    private Integer id;
    @XmlElement
    private String name;
    @XmlElement
    private ServerInfo serverInfo;
    @XmlElement
    private ServerAuthentication serverAuthentication;

    public RestServer(Server server) {
        Preconditions.checkNotNull((Object)server);
        this.id = server.getID();
        this.name = server.getName();
        this.serverInfo = new ServerInfo(server.getConnectionProtocol(), server.getHost(), server.getPort());
        this.serverAuthentication = new ServerAuthentication(server.getAuthenticationMethod(), server.getSshKey(), server.getUsername(), this.getMaskedPassword(server.getPassword()));
    }

    public static Collection<RestServer> collection(Collection<? extends Server> repositories) {
        return Collections2.transform(repositories, (Function)new Transformer());
    }

    public Integer getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public ServerInfo getServerInfo() {
        return this.serverInfo;
    }

    public ServerAuthentication getServerAuthentication() {
        return this.serverAuthentication;
    }

    private String getMaskedPassword(String password) {
        if (!Strings.isNullOrEmpty((String)password)) {
            return PASSWORD_MASK;
        }
        return password;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setServerInfo(ServerInfo serverInfo) {
        this.serverInfo = serverInfo;
    }

    public void setServerAuthentication(ServerAuthentication serverAuthentication) {
        this.serverAuthentication = serverAuthentication;
    }

    public static class Transformer
    implements Function<Server, RestServer> {
        @Nullable
        public RestServer apply(@Nullable Server server) {
            return new RestServer(server);
        }
    }
}

