(function ($) {
    var GitPlugin = function () {
    };

    function toggleNonApplicableMarkdownOptions(path) {
        var codeParameters = ["#macro-param-language", "#macro-param-collapse", "#macro-param-linenumbers", "#macro-param-firstline", "#macro-param-lastline", "#macro-param-theme"];
        var markdownParameters = ["#macro-param-renderpanel"];

        _.forEach(codeParameters, function (id) {
            $(id).prop("disabled", path.toLowerCase().endsWith(".md"));
        });
    }

    function toggleNonApplicablePlantUMLOptions(path) {
        var codeParameters = ["#macro-param-language", "#macro-param-title", "#macro-param-collapse", "#macro-param-linenumbers", "#macro-param-firstline", "#macro-param-theme"];
        var markdownParameters = ["#macro-param-renderpuml"];

        _.forEach(codeParameters, function (id) {
            $(id).prop("disabled", path.toLowerCase().endsWith(".puml"));
        });

        _.forEach(markdownParameters, function (id) {
            $(id).prop("disabled", !path.toLowerCase().endsWith(".puml"));
        });
    }

    function normalizeRef(ref) {
        return ref
            .replace("refs/tags/", "")
            .replace("refs/heads/", "")
            .replace("refs/remotes/" + "origin" + "/", "");
    }

    GitPlugin.prototype.beforeParamsSet = function (selectedParams, macroSelected) {
        
        var $repositorySelect = AJS.$("#macro-param-repository-id");
        var $branchSelect = AJS.$("#macro-param-branch");
        var $commitSelect = AJS.$("#macro-param-commit-id");
        var $pathInput = AJS.$("#macro-param-path");
        var $folderInput = AJS.$("#macro-param-folder");
        var $syntaxInput = AJS.$("#macro-param-language");

        var repositoryOptions = {};

        if (!_.isEmpty(selectedParams["repository-id"])) {
            repositoryOptions.initialValue = parseInt(selectedParams["repository-id"]);
        }

        var branchOptions = {
            repository: function () {
                return $repositorySelect.val();
            }
        };

        if (!_.isEmpty(selectedParams["branch"])) {
            branchOptions.initialValue = normalizeRef(selectedParams["branch"]);
        }

        var commitOptions = {
            repository: function () {
                return $repositorySelect.val();
            },
            branch: function () {
                return $branchSelect.val();
            }
        };

        if (!_.isEmpty(selectedParams["commit-id"])) {
            commitOptions.initialValue = selectedParams["commit-id"];
        }

        var pathOptions = {
            repository: function () {
                return $repositorySelect.val();
            },
            branch: function () {
                return $branchSelect.val();
            },
            commitId: function () {
                return $commitSelect.val();
            }
        };

        var folderOptions = {
            repository: function () {
                return $repositorySelect.val();
            },
            branch: function () {
                return $branchSelect.val();
            },
            commitId: function () {
                return $commitSelect.val();
            }
        };

        var languageOptions = {
        };

        if (!_.isEmpty(selectedParams["language"])) {
            languageOptions.initialValue = selectedParams["language"];
        }

        if (!_.isEmpty(selectedParams["path"])) {
            pathOptions.initialValue = selectedParams["path"];
            toggleNonApplicableMarkdownOptions(selectedParams["path"]);
        }

        // This solves validation errors when .macro-param-input exists multiple times the macro browser validation fails;r
        var selects = [$repositorySelect, $branchSelect, $commitSelect, $pathInput, $folderInput];
        $.each(selects, function () {
            this.removeClass('macro-param-input');
        });

        $repositorySelect.gitPluginRepositorySelect(repositoryOptions);
        $branchSelect.gitPluginBranchSelect(branchOptions);
        $commitSelect.gitPluginCommitSelect(commitOptions)
        $pathInput.gitRepositoryFileAutocompleter(pathOptions);
        $folderInput.gitRepositoryFolderAutocompleter(folderOptions);
        $syntaxInput.gitPluginSyntaxSelect(languageOptions);

        $pathInput.on("change", function () {
            toggleNonApplicableMarkdownOptions($(this).val());
        });

        $.each(selects, function () {
            this.addClass('macro-param-input');

            // Fix for the bug where a new tab opens when clicking on select2
            this.parent().find('a').on("click", function (e) {
                e.stopImmediatePropagation();
            });
        });

        return selectedParams;
    };

    AJS.MacroBrowser.setMacroJsOverride("list-git-folder", new GitPlugin());
    AJS.MacroBrowser.setMacroJsOverride("view-git-file", new GitPlugin());
})(AJS.$);
