jQuery(function ($) {
    $("body").append("<div id='git-plugin-global-message'></div>");

    $(document).on("click", "#configure-git-attachment-menu-item", function (e) {
        e.preventDefault();
        var id = "configure-git-attachment-dialog";
        var messagesContext = "#git-plugin-global-message";
        var dialog = new AJS.ConfluenceDialog({
            width: 865,
            height: 350,
            id: id,
            closeOnOutsideClick: false,
            onCancel: function () {
                dialog.hide().remove();
            }
        });
        var $dialog = $("#" + id);

        dialog.addHeader(AJS.I18n.getText("gitplugin.attachment.dialog.title"));
        dialog.addPanel("default", Confluence.Templates.ConfigureGitAttachment.dialogContent({
            contentId: AJS.Confluence.getContentId()
        }));

        var submitForm = function () {
            dialog.disable();
            var formData = $dialog.find("form").serializeObject();
            AJS.$(messagesContext).empty();
            $dialog.find(".button-panel-button").append("<span class=\"aui-icon aui-icon-wait\"></span>");
            var xhr = AJS.$.ajax({
                url: AJS.contextPath() + "/rest/git-plugin/1.0/attachments",
                type: "POST",
                contentType: 'application/json',
                data: JSON.stringify(formData),
                error: function (data) {
                    if (data.status === 409) {
                        AJS.messages.error("#configure-git-attachment-dialog-messages", {
                            title: AJS.I18n.getText("gitplugin.attachment.dialog.notification.filename.error.title"),
                            body: "<p>" + AJS.I18n.getText("gitplugin.attachment.dialog.notification.filename.error.body") + "</p>",
                            closeable: false
                        });
                    } else {
                        AJS.$("#configure-git-attachment-dialog-messages").empty();
                        // For now we just say we can't find the file maybe we can implement other error messages.
                        AJS.messages.error("#configure-git-attachment-dialog-messages", {
                            title: AJS.I18n.getText("gitplugin.attachment.dialog.notification.error.title"),
                            body: "<p>" + AJS.I18n.getText("gitplugin.attachment.dialog.notification.error.body", formData.path) + "</p>",
                            closeable: false
                    });
                    }
                    dialog.updateHeight();
                    dialog.enable();
                },
                success: function (repositories) {
                    var $attachmentCounter = $(".page-metadata-attachments-count");
                    $attachmentCounter.html(parseInt($attachmentCounter.text()) + 1);

                    AJS.messages.success(messagesContext, {
                        title: AJS.I18n.getText("gitplugin.attachment.dialog.notification.succes.title"),
                        body: "<p>" + AJS.I18n.getText("gitplugin.attachment.dialog.notification.succes.body", formData.path) + "</p>",
                        fadeout: true
                    });
                    dialog.enable();
                    dialog.hide().remove();
                }
            });
            xhr.complete(function () {
                $dialog.find(".button-panel-button span").remove();
            });
            return false;
        };

        $dialog.find("form").on('submit', submitForm);

        dialog.addButton(AJS.I18n.getText("gitplugin.attachment.dialog.submit"), submitForm);
        dialog.addCancel(AJS.I18n.getText("close.name"), function () {
            dialog.hide().remove();
            return false;
        });
        dialog.show();


        $dialog.find("#repository-select").gitPluginRepositorySelect();

        AJS.$("#branch-select").gitPluginBranchSelect({
            repository: function () {
                return AJS.$("#repository-select").val();
            }
        });

        AJS.$("#commit-select").gitPluginCommitSelect({
            branch: function () {
                return AJS.$("#branch-select").val();
            },
            repository: function () {
                return AJS.$("#repository-select").val();
            }
        });

        AJS.$("#file-path").gitRepositoryFileAutocompleter({
            repository: function () {
                return AJS.$("#repository-select").val();
            },
            branch: function () {
                return AJS.$("#branch-select").val();
            },
            commit: function () {
                return AJS.$("#commit-select").val();
            }
        });

        AJS.$("#folder-path").gitRepositoryFolderAutocompleter({
            repository: function () {
                return AJS.$("#repository-select").val();
            },
            branch: function () {
                return AJS.$("#branch-select").val();
            },
            commit: function () {
                return AJS.$("#commit-select").val();
            }
        });

    });
});
