/*
 * Decompiled with CFR 0.152.
 */
package nl.avisi.confluence.plugins.gitplugin.configuration.rest.mappers;

import com.atlassian.confluence.api.service.exceptions.ReadOnlyException;
import com.atlassian.sal.api.message.I18nResolver;
import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import nl.avisi.confluence.plugins.gitplugin.exceptions.RestError;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
public class GlobalExceptionMapper
implements ExceptionMapper<Throwable> {
    private static final Logger LOGGER = LoggerFactory.getLogger(GlobalExceptionMapper.class);
    private final I18nResolver i18nResolver;
    private static final Logger LOG = LoggerFactory.getLogger(GlobalExceptionMapper.class);

    public GlobalExceptionMapper(@Nonnull I18nResolver i18nResolver) {
        this.i18nResolver = (I18nResolver)Preconditions.checkNotNull((Object)i18nResolver);
    }

    public Response toResponse(Throwable exception) {
        if (exception instanceof ReadOnlyException) {
            LOG.warn("Read-only mode is currently enabled");
            return Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).entity((Object)new RestError("Read-Only mode is currently enabled.")).build();
        }
        LOG.warn("There was an unexpected error in the Git Rest Resource thrown.", exception);
        return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)new RestError(this.i18nResolver.getText(exception.getMessage()))).build();
    }
}

