/*
 * Decompiled with CFR 0.152.
 */
package nl.avisi.confluence.plugins.gitplugin.configuration.rest;

import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import javax.inject.Named;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import nl.avisi.confluence.plugins.gitplugin.configuration.rest.LicenseCheckBaseResource;
import nl.avisi.confluence.plugins.gitplugin.configuration.rest.Utils;
import nl.avisi.confluence.plugins.gitplugin.core.Server;
import nl.avisi.confluence.plugins.gitplugin.git.progress.TaskProgressStore;
import nl.avisi.confluence.plugins.gitplugin.license.LicenseChecker;

@Named
@Path(value="/progress")
@Produces(value={"application/json"})
public class ProgressResource
extends LicenseCheckBaseResource {
    private final TaskProgressStore taskProgressStore;
    private final Utils utils;

    @Inject
    public ProgressResource(@Nonnull TaskProgressStore taskProgressStore, @Nonnull LicenseChecker licenseChecker, Utils utils) {
        super(licenseChecker);
        this.taskProgressStore = (TaskProgressStore)Preconditions.checkNotNull((Object)taskProgressStore);
        this.utils = utils;
    }

    @GET
    @Path(value="/{serverId}")
    public Response get(@PathParam(value="serverId") String serverId) {
        this.checkLicense();
        Server server = this.utils.serverIdToServer(serverId);
        return Response.ok(this.taskProgressStore.get(server.getID())).build();
    }
}

