/*
 * Decompiled with CFR 0.152.
 */
package nl.avisi.confluence.plugins.gitplugin.configuration.rest;

import com.atlassian.confluence.compat.api.service.accessmode.AccessModeCompatService;
import com.atlassian.confluence.content.service.PageService;
import com.atlassian.confluence.search.ConfluenceIndexer;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.config.JobConfig;
import com.atlassian.scheduler.config.JobId;
import com.google.common.base.Preconditions;
import java.util.Date;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import javax.inject.Named;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import nl.avisi.confluence.plugins.compat.CompatibilityApi;
import nl.avisi.confluence.plugins.gitplugin.configuration.dao.RepositoryDao;
import nl.avisi.confluence.plugins.gitplugin.configuration.service.RepositoryHealthCheckService;
import nl.avisi.confluence.plugins.gitplugin.configuration.service.RepositoryService;
import nl.avisi.confluence.plugins.gitplugin.git.jobs.PullJob;
import nl.avisi.confluence.plugins.gitplugin.git.manager.VCSRepositoryManager;
import nl.avisi.confluence.plugins.gitplugin.license.LicenseChecker;

@Named
@Path(value="/jobs")
@Produces(value={"application/json"})
public class JobResource {
    private final RepositoryService repositoryService;
    private final LicenseChecker licenseChecker;
    private final I18nResolver i18nResolver;
    private final TransactionTemplate transactionTemplate;
    private final AccessModeCompatService accessModeService;
    private final ConfluenceIndexer confluenceIndexer;
    private final PageService pageService;
    private final VCSRepositoryManager repositoryManager;
    private final RepositoryDao repositoryDao;
    private final RepositoryHealthCheckService repositoryHealthCheckService;
    private final CompatibilityApi compatibilityApi;

    @Inject
    public JobResource(@Nonnull RepositoryService repositoryService, @Nonnull LicenseChecker licenseChecker, @ComponentImport I18nResolver i18nResolver, @ComponentImport TransactionTemplate transactionTemplate, AccessModeCompatService accessModeService, @ComponentImport ConfluenceIndexer confluenceIndexer, @ComponentImport PageService pageService, VCSRepositoryManager repositoryManager, RepositoryDao repositoryDao, RepositoryHealthCheckService repositoryHealthCheckService, CompatibilityApi compatibilityApi) {
        this.transactionTemplate = (TransactionTemplate)Preconditions.checkNotNull((Object)transactionTemplate);
        this.repositoryService = (RepositoryService)Preconditions.checkNotNull((Object)repositoryService);
        this.licenseChecker = (LicenseChecker)Preconditions.checkNotNull((Object)licenseChecker);
        this.i18nResolver = (I18nResolver)Preconditions.checkNotNull((Object)i18nResolver);
        this.accessModeService = (AccessModeCompatService)Preconditions.checkNotNull((Object)accessModeService);
        this.confluenceIndexer = confluenceIndexer;
        this.pageService = pageService;
        this.repositoryManager = repositoryManager;
        this.repositoryDao = repositoryDao;
        this.repositoryHealthCheckService = repositoryHealthCheckService;
        this.compatibilityApi = compatibilityApi;
    }

    @GET
    @Path(value="/update-repositories")
    public Response updateRepositories() throws Exception {
        PullJob pullJob = new PullJob(this.repositoryService, this.licenseChecker, this.i18nResolver, this.transactionTemplate, this.accessModeService, this.repositoryManager, this.pageService, this.confluenceIndexer, this.repositoryDao, this.repositoryHealthCheckService, this.compatibilityApi);
        pullJob.runJob(new JobRunnerRequest(){

            @Nonnull
            public Date getStartTime() {
                return null;
            }

            @Nonnull
            public JobId getJobId() {
                return null;
            }

            @Nonnull
            public JobConfig getJobConfig() {
                return null;
            }

            public boolean isCancellationRequested() {
                return false;
            }
        });
        return Response.ok().build();
    }
}

