(function($) {

  $.fn.gitPluginRepositorySelect = function(options) {
    var cache = [];
    var $element = this;

    var settings = $.extend({}, options);

    $element.auiSelect2({
      placeholder : AJS.I18n.getText("gitplugin.attachment.dialog.repository.select"),
      minimumInputLength : 0,
      width : "100%",
      closeOnSelect : true,
      dropdownCssClass : "git-plugin-show-full-select2-option",
      adaptContainerCssClass : function(clazz) {
        // filter out macro-param-input for macro browser issues
        if (clazz === "macro-param-input") {
          return null
        }
        return clazz;
      },
      sortResults : function(results, container, query) {
        if (query.term) {
          return results.sort(function(a, b) {
            var aLower = a.text.toLowerCase().indexOf(query.term.toLowerCase());
            var bLower = b.text.toLowerCase().indexOf(query.term.toLowerCase());
            if (aLower < bLower) {
              return 1;
            } else if (aLower > bLower) {
              return -1;
            } else {
              return 0;
            }
          });
        }

        return results;
      },
      query : function(query) {
        if (cache.length > 0) {
          query.callback({results : cache});
        } else {
          AJS.$.ajax({
            url : AJS.contextPath() + "/rest/git-plugin/1.0/repositories",
            dataType : 'json',
            cache : false,
            error : function(xhr) {
              query.callback({results : []});
            },
            success : function(repositories) {
              for (var i = 0; i < repositories.length; i++) {
                var repository = repositories[i];
                if (!repository.archived) {
                  cache.push({id : repositories[i].id, text : repositories[i].serverName + "/" + repositories[i].name});
                }
              }
              query.callback({results : cache});
            }
          });
        }
      }
    });

    if (settings.initialValue > 0) {
      AJS.$.ajax({
        url : AJS.contextPath() + "/rest/git-plugin/1.0/repositories/" + settings.initialValue,
        dataType : 'json',
        cache : false,
        success : function(repository) {
          $element.auiSelect2("data", {id : repository.id, text : repository.serverName + "/" + repository.name});
        }
      });
    }

    return this;
  }

}(AJS.$));
