/*
 * Decompiled with CFR 0.152.
 */
package nl.avisi.confluence.plugins.gitplugin.upgrades;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.activeobjects.external.ActiveObjectsUpgradeTask;
import com.atlassian.activeobjects.external.ModelVersion;
import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import nl.avisi.confluence.plugins.gitplugin.configuration.dao.ActiveObjectsRepositoryDao;
import nl.avisi.confluence.plugins.gitplugin.configuration.dao.ActiveObjectsServerDao;
import nl.avisi.confluence.plugins.gitplugin.configuration.dao.RepositoryDao;
import nl.avisi.confluence.plugins.gitplugin.configuration.dao.ServerDao;
import nl.avisi.confluence.plugins.gitplugin.core.Repository;
import nl.avisi.confluence.plugins.gitplugin.core.Server;
import nl.avisi.confluence.plugins.gitplugin.core.ServerAuthentication;
import nl.avisi.confluence.plugins.gitplugin.core.ServerInfo;
import nl.avisi.confluence.plugins.gitplugin.git.exception.RepositoryInitializationException;
import nl.avisi.confluence.plugins.gitplugin.git.manager.VCSRepositoryManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InitialDataImporter
implements ActiveObjectsUpgradeTask {
    private static final Logger LOG = LoggerFactory.getLogger(ActiveObjectsUpgradeTask.class);
    private final VCSRepositoryManager repositoryManager;

    public InitialDataImporter(@Nonnull VCSRepositoryManager repositoryManager) {
        this.repositoryManager = (VCSRepositoryManager)Preconditions.checkNotNull((Object)repositoryManager);
    }

    public ModelVersion getModelVersion() {
        return ModelVersion.valueOf((String)"100500301");
    }

    public void upgrade(ModelVersion modelVersion, ActiveObjects activeObjects) {
        ActiveObjectsServerDao serverDao = new ActiveObjectsServerDao(activeObjects);
        ActiveObjectsRepositoryDao repositoryDao = new ActiveObjectsRepositoryDao(activeObjects);
        this.createExampleRepository(serverDao, repositoryDao, "GitHub", "github.com", "Git for Confluence reference", "/avisi-apps/git-for-confluence-reference.git");
        this.createExampleRepository(serverDao, repositoryDao, "Bitbucket", "bitbucket.org", "Confluence Git Add-on test repository", "/avisi/confluence-git-add-on-test-repository.git");
    }

    private void createExampleRepository(ServerDao serverDao, RepositoryDao repositoryDao, String serverName, String host, String repositoryName, String repositoryPath) {
        if (serverDao.getByHost(host).isPresent()) {
            return;
        }
        try {
            Server server = serverDao.createServer(serverName, new ServerInfo(Server.ConnectionProtocol.HTTPS, host, Integer.valueOf(443)), new ServerAuthentication(Server.AuthenticationMethod.NO_AUTHENTICATION, null, null, null));
            Repository repository = repositoryDao.create(server, repositoryName, repositoryPath);
            this.repositoryManager.create(repository);
        }
        catch (RepositoryInitializationException e) {
            LOG.error("Failed to initialize example repositories", (Throwable)e);
        }
    }
}

