/*
 * Decompiled with CFR 0.152.
 */
package nl.avisi.confluence.plugins.gitplugin.configuration.service;

import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.user.EntityException;
import com.atlassian.user.Group;
import com.atlassian.user.GroupManager;
import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import nl.avisi.confluence.plugins.gitplugin.configuration.dao.GroupDao;
import nl.avisi.confluence.plugins.gitplugin.configuration.service.SecurityService;
import nl.avisi.confluence.plugins.gitplugin.core.Repository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
public class SecurityServiceImpl
implements SecurityService {
    private final GroupDao groupDao;
    private final GroupManager groupManager;
    private final UserManager userManager;
    private static final Logger LOG = LoggerFactory.getLogger(SecurityServiceImpl.class);

    @Inject
    public SecurityServiceImpl(GroupDao groupDao, @ComponentImport GroupManager groupManager, @ComponentImport UserManager userManager) {
        this.groupDao = groupDao;
        this.groupManager = groupManager;
        this.userManager = userManager;
    }

    @Override
    public void addGroups(Repository repository, List<String> groups) {
        for (String group : groups) {
            this.groupDao.save(group, repository);
        }
    }

    @Override
    public void clearGroups(Repository repository) {
        this.groupDao.delete(repository.getGroups());
    }

    @Override
    public List<String> getAllGroups() throws EntityException {
        return Lists.transform((List)Lists.newArrayList((Iterator)this.groupManager.getGroups().iterator()), (Function)new Function<Group, String>(){

            public String apply(Group input) {
                return input.getName();
            }
        });
    }

    @Override
    public boolean canUse(Repository repository) {
        ArrayList groups = Lists.newArrayList((Object[])repository.getGroups());
        String currentUser = this.userManager.getRemoteUsername();
        LOG.debug("Checking if user '{}' can use repository '{}'", (Object)currentUser, (Object)repository.getName());
        if (groups.isEmpty()) {
            LOG.debug("Yes - Repository has no groups configured");
            return true;
        }
        LOG.debug("The following groups are configured for this repository; {}", this.extractNamesFromGroups(groups));
        for (nl.avisi.confluence.plugins.gitplugin.core.Group group : groups) {
            if (!this.userManager.isUserInGroup(currentUser, group.getName())) continue;
            LOG.debug("Yes - User is in group {}", (Object)group.getName());
            return true;
        }
        LOG.debug("No - User not in any of the configured groups");
        return false;
    }

    private Collection<String> extractNamesFromGroups(Collection<nl.avisi.confluence.plugins.gitplugin.core.Group> groups) {
        return Collections2.transform(groups, (Function)new Function<nl.avisi.confluence.plugins.gitplugin.core.Group, String>(){

            public String apply(@Nullable nl.avisi.confluence.plugins.gitplugin.core.Group group) {
                return group.getName();
            }
        });
    }
}

